/*
 * Decompiled with CFR 0.152.
 */
package io.github.hengyunabc.zabbix.sender;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.hengyunabc.zabbix.sender.DataObject;
import io.github.hengyunabc.zabbix.sender.SenderRequest;
import io.github.hengyunabc.zabbix.sender.SenderResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;

public class ZabbixSender {
    private static final Pattern PATTERN = Pattern.compile("[^0-9\\.]+");
    String host;
    int port;
    int connectTimeout = 3000;
    int socketTimeout = 3000;

    public ZabbixSender(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ZabbixSender(String host, int port, int connectTimeout, int socketTimeout) {
        this(host, port);
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    public SenderResult send(DataObject dataObject) throws IOException {
        return this.send(dataObject, System.currentTimeMillis() / 1000L);
    }

    public SenderResult send(DataObject dataObject, long clock) throws IOException {
        return this.send(Collections.singletonList(dataObject), clock);
    }

    public SenderResult send(List<DataObject> dataObjectList) throws IOException {
        return this.send(dataObjectList, System.currentTimeMillis() / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SenderResult send(List<DataObject> dataObjectList, long clock) throws IOException {
        SenderResult senderResult = new SenderResult();
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int read;
            socket = new Socket();
            socket.setSoTimeout(this.socketTimeout);
            socket.connect(new InetSocketAddress(this.host, this.port), this.connectTimeout);
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            SenderRequest senderRequest = new SenderRequest();
            senderRequest.setData(dataObjectList);
            senderRequest.setClock(clock);
            outputStream.write(senderRequest.toBytes());
            outputStream.flush();
            byte[] responseData = new byte[512];
            int readCount = 0;
            while ((read = inputStream.read(responseData, readCount, responseData.length - readCount)) > 0) {
                readCount += read;
            }
            if (readCount < 13) {
                senderResult.setbReturnEmptyArray(true);
            }
            String jsonString = new String(responseData, 13, readCount - 13, Charsets.UTF_8);
            JSONObject json = JSON.parseObject((String)jsonString);
            String info = json.getString("info");
            String[] split = PATTERN.split(info);
            senderResult.setProcessed(Integer.parseInt(split[1]));
            senderResult.setFailed(Integer.parseInt(split[2]));
            senderResult.setTotal(Integer.parseInt(split[3]));
            senderResult.setSpentSeconds(Float.parseFloat(split[4]));
        }
        finally {
            if (socket != null) {
                socket.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return senderResult;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }
}

