/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie;

import io.github.linpeilie.BaseCycleAvoidingMapper;
import io.github.linpeilie.BaseMapMapper;
import io.github.linpeilie.BaseMapper;
import io.github.linpeilie.ConverterFactory;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCachedConverterFactory
implements ConverterFactory {
    private final ConcurrentHashMap<String, BaseMapper> mapperMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BaseCycleAvoidingMapper> cycleAvoidingMapper = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BaseMapMapper> mapMapperMap = new ConcurrentHashMap();

    @Override
    public <S, T> BaseMapper<S, T> getMapper(Class<S> sourceType, Class<T> targetType) {
        Class<?> target;
        Class<?> source = this.wrapperClass(sourceType);
        String key = this.key(source, target = this.wrapperClass(targetType));
        if (this.mapperMap.containsKey(key)) {
            return this.mapperMap.get(key);
        }
        BaseMapper mapper = this.findMapper(source, target);
        if (mapper != null) {
            this.mapperMap.put(key, mapper);
            return mapper;
        }
        return null;
    }

    @Override
    public <S, T> BaseCycleAvoidingMapper<S, T> getCycleAvoidingMapper(Class<S> sourceType, Class<T> targetType) {
        BaseMapper<S, T> mapper = this.getMapper(sourceType, targetType);
        if (mapper == null) {
            return null;
        }
        if (mapper instanceof BaseCycleAvoidingMapper) {
            return (BaseCycleAvoidingMapper)mapper;
        }
        return null;
    }

    @Override
    public <S> BaseMapMapper<S> getMapMapper(Class<S> sourceType) {
        Class<?> source = this.wrapperClass(sourceType);
        String key = source.getName();
        if (this.mapMapperMap.containsKey(key)) {
            return this.mapMapperMap.get(key);
        }
        BaseMapMapper mapper = this.findMapMapper(source);
        if (mapper != null) {
            this.mapMapperMap.put(key, mapper);
            return mapper;
        }
        return null;
    }

    protected Class<?> wrapperClass(Class<?> clazz) {
        return clazz;
    }

    protected abstract <S, T> BaseMapper findMapper(Class<S> var1, Class<T> var2);

    protected abstract <S> BaseMapMapper findMapMapper(Class<?> var1);

    private String key(Class<?> source, Class<?> target) {
        return source.getName() + "__" + target.getName();
    }
}

