/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j;

import io.github.lnyocly.ai4j.DeepSeekConfigProperties;
import io.github.lnyocly.ai4j.HunyuanConfigProperties;
import io.github.lnyocly.ai4j.LingyiConfigProperties;
import io.github.lnyocly.ai4j.MoonshotConfigProperties;
import io.github.lnyocly.ai4j.OkHttpConfigProperties;
import io.github.lnyocly.ai4j.OllamaConfigProperties;
import io.github.lnyocly.ai4j.OpenAiConfigProperties;
import io.github.lnyocly.ai4j.PineconeConfigProperties;
import io.github.lnyocly.ai4j.ZhipuConfigProperties;
import io.github.lnyocly.ai4j.config.DeepSeekConfig;
import io.github.lnyocly.ai4j.config.HunyuanConfig;
import io.github.lnyocly.ai4j.config.LingyiConfig;
import io.github.lnyocly.ai4j.config.MoonshotConfig;
import io.github.lnyocly.ai4j.config.OllamaConfig;
import io.github.lnyocly.ai4j.config.OpenAiConfig;
import io.github.lnyocly.ai4j.config.PineconeConfig;
import io.github.lnyocly.ai4j.config.ZhipuConfig;
import io.github.lnyocly.ai4j.interceptor.ContentTypeInterceptor;
import io.github.lnyocly.ai4j.interceptor.ErrorInterceptor;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.factor.AiService;
import io.github.lnyocly.ai4j.utils.OkHttpUtil;
import io.github.lnyocly.ai4j.vector.service.PineconeService;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.PostConstruct;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={OpenAiConfigProperties.class, OkHttpConfigProperties.class, PineconeConfigProperties.class, ZhipuConfigProperties.class, DeepSeekConfigProperties.class, MoonshotConfigProperties.class, HunyuanConfigProperties.class, LingyiConfigProperties.class, OllamaConfigProperties.class})
public class AiConfigAutoConfiguration {
    private final OkHttpConfigProperties okHttpConfigProperties;
    private final PineconeConfigProperties pineconeConfigProperties;
    private final OpenAiConfigProperties openAiConfigProperties;
    private final ZhipuConfigProperties zhipuConfigProperties;
    private final DeepSeekConfigProperties deepSeekConfigProperties;
    private final MoonshotConfigProperties moonshotConfigProperties;
    private final HunyuanConfigProperties hunyuanConfigProperties;
    private final LingyiConfigProperties lingyiConfigProperties;
    private final OllamaConfigProperties ollamaConfigProperties;
    private Configuration configuration = new Configuration();

    public AiConfigAutoConfiguration(OkHttpConfigProperties okHttpConfigProperties, OpenAiConfigProperties openAiConfigProperties, PineconeConfigProperties pineconeConfigProperties, ZhipuConfigProperties zhipuConfigProperties, DeepSeekConfigProperties deepSeekConfigProperties, MoonshotConfigProperties moonshotConfigProperties, HunyuanConfigProperties hunyuanConfigProperties, LingyiConfigProperties lingyiConfigProperties, OllamaConfigProperties ollamaConfigProperties) {
        this.okHttpConfigProperties = okHttpConfigProperties;
        this.openAiConfigProperties = openAiConfigProperties;
        this.pineconeConfigProperties = pineconeConfigProperties;
        this.zhipuConfigProperties = zhipuConfigProperties;
        this.deepSeekConfigProperties = deepSeekConfigProperties;
        this.moonshotConfigProperties = moonshotConfigProperties;
        this.hunyuanConfigProperties = hunyuanConfigProperties;
        this.lingyiConfigProperties = lingyiConfigProperties;
        this.ollamaConfigProperties = ollamaConfigProperties;
    }

    @Bean
    public AiService aiService() {
        return new AiService(this.configuration);
    }

    @Bean
    public PineconeService pineconeService() {
        return new PineconeService(this.configuration);
    }

    @PostConstruct
    private void init() {
        this.initOkHttp();
        this.initPineconeConfig();
        this.initOpenAiConfig();
        this.initZhipuConfig();
        this.initDeepSeekConfig();
        this.initMoonshotConfig();
        this.initHunyuanConfig();
        this.initLingyiConfig();
        this.initOllamaConfig();
    }

    private void initOkHttp() {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(this.okHttpConfigProperties.getLog());
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)httpLoggingInterceptor).addInterceptor((Interceptor)new ErrorInterceptor()).addInterceptor((Interceptor)new ContentTypeInterceptor()).connectTimeout((long)this.okHttpConfigProperties.getConnectTimeout(), this.okHttpConfigProperties.getTimeUnit()).writeTimeout((long)this.okHttpConfigProperties.getWriteTimeout(), this.okHttpConfigProperties.getTimeUnit()).readTimeout((long)this.okHttpConfigProperties.getReadTimeout(), this.okHttpConfigProperties.getTimeUnit());
        if (StringUtils.isNotBlank((CharSequence)this.okHttpConfigProperties.getProxyUrl())) {
            Proxy proxy = new Proxy(this.okHttpConfigProperties.getProxyType(), new InetSocketAddress(this.okHttpConfigProperties.getProxyUrl(), this.okHttpConfigProperties.getProxyPort()));
            okHttpBuilder.proxy(proxy);
        }
        if (this.okHttpConfigProperties.isIgnoreSsl()) {
            try {
                okHttpBuilder.sslSocketFactory(OkHttpUtil.getIgnoreInitedSslContext().getSocketFactory(), OkHttpUtil.IGNORE_SSL_TRUST_MANAGER_X509).hostnameVerifier(OkHttpUtil.getIgnoreSslHostnameVerifier());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
        OkHttpClient okHttpClient = okHttpBuilder.build();
        this.configuration.setOkHttpClient(okHttpClient);
    }

    private void initOpenAiConfig() {
        OpenAiConfig openAiConfig = new OpenAiConfig();
        openAiConfig.setApiHost(this.openAiConfigProperties.getApiHost());
        openAiConfig.setApiKey(this.openAiConfigProperties.getApiKey());
        openAiConfig.setChatCompletionUrl(this.openAiConfigProperties.getChatCompletionUrl());
        openAiConfig.setEmbeddingUrl(this.openAiConfigProperties.getEmbeddingUrl());
        openAiConfig.setSpeechUrl(this.openAiConfigProperties.getSpeechUrl());
        openAiConfig.setTranscriptionUrl(this.openAiConfigProperties.getTranscriptionUrl());
        openAiConfig.setTranslationUrl(this.openAiConfigProperties.getTranslationUrl());
        this.configuration.setOpenAiConfig(openAiConfig);
    }

    private void initZhipuConfig() {
        ZhipuConfig zhipuConfig = new ZhipuConfig();
        zhipuConfig.setApiHost(this.zhipuConfigProperties.getApiHost());
        zhipuConfig.setApiKey(this.zhipuConfigProperties.getApiKey());
        zhipuConfig.setChatCompletionUrl(this.zhipuConfigProperties.getChatCompletionUrl());
        zhipuConfig.setEmbeddingUrl(this.zhipuConfigProperties.getEmbeddingUrl());
        this.configuration.setZhipuConfig(zhipuConfig);
    }

    private void initPineconeConfig() {
        PineconeConfig pineconeConfig = new PineconeConfig();
        pineconeConfig.setHost(this.pineconeConfigProperties.getHost());
        pineconeConfig.setKey(this.pineconeConfigProperties.getKey());
        pineconeConfig.setUpsert(this.pineconeConfigProperties.getUpsert());
        pineconeConfig.setQuery(this.pineconeConfigProperties.getQuery());
        pineconeConfig.setDelete(this.pineconeConfigProperties.getDelete());
        this.configuration.setPineconeConfig(pineconeConfig);
    }

    private void initDeepSeekConfig() {
        DeepSeekConfig deepSeekConfig = new DeepSeekConfig();
        deepSeekConfig.setApiHost(this.deepSeekConfigProperties.getApiHost());
        deepSeekConfig.setApiKey(this.deepSeekConfigProperties.getApiKey());
        deepSeekConfig.setChatCompletionUrl(this.deepSeekConfigProperties.getChatCompletionUrl());
        this.configuration.setDeepSeekConfig(deepSeekConfig);
    }

    private void initMoonshotConfig() {
        MoonshotConfig moonshotConfig = new MoonshotConfig();
        moonshotConfig.setApiHost(this.moonshotConfigProperties.getApiHost());
        moonshotConfig.setApiKey(this.moonshotConfigProperties.getApiKey());
        moonshotConfig.setChatCompletionUrl(this.moonshotConfigProperties.getChatCompletionUrl());
        this.configuration.setMoonshotConfig(moonshotConfig);
    }

    private void initHunyuanConfig() {
        HunyuanConfig hunyuanConfig = new HunyuanConfig();
        hunyuanConfig.setApiHost(this.hunyuanConfigProperties.getApiHost());
        hunyuanConfig.setApiKey(this.hunyuanConfigProperties.getApiKey());
        this.configuration.setHunyuanConfig(hunyuanConfig);
    }

    private void initLingyiConfig() {
        LingyiConfig lingyiConfig = new LingyiConfig();
        lingyiConfig.setApiHost(this.lingyiConfigProperties.getApiHost());
        lingyiConfig.setApiKey(this.lingyiConfigProperties.getApiKey());
        lingyiConfig.setChatCompletionUrl(this.lingyiConfigProperties.getChatCompletionUrl());
        this.configuration.setLingyiConfig(lingyiConfig);
    }

    private void initOllamaConfig() {
        OllamaConfig ollamaConfig = new OllamaConfig();
        ollamaConfig.setApiHost(this.ollamaConfigProperties.getApiHost());
        ollamaConfig.setChatCompletionUrl(this.ollamaConfigProperties.getChatCompletionUrl());
        ollamaConfig.setEmbeddingUrl(this.ollamaConfigProperties.getEmbeddingUrl());
        this.configuration.setOllamaConfig(ollamaConfig);
    }
}

