/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.exception.chain;

import io.github.lnyocly.ai4j.exception.chain.IErrorHandler;
import io.github.lnyocly.ai4j.exception.chain.impl.HunyuanErrorHandler;
import io.github.lnyocly.ai4j.exception.chain.impl.OpenAiErrorHandler;
import io.github.lnyocly.ai4j.exception.chain.impl.UnknownErrorHandler;
import io.github.lnyocly.ai4j.exception.error.Error;
import java.util.ArrayList;
import java.util.List;

public class ErrorHandler {
    private List<IErrorHandler> handlers = new ArrayList<IErrorHandler>();
    private IErrorHandler chain;

    private ErrorHandler() {
        this.handlers.add(new OpenAiErrorHandler());
        this.handlers.add(new HunyuanErrorHandler());
        this.handlers.add(new UnknownErrorHandler());
        this.assembleChain();
    }

    private void assembleChain() {
        this.chain = this.handlers.get(0);
        IErrorHandler curr = this.handlers.get(0);
        for (int i = 1; i < this.handlers.size(); ++i) {
            curr.setNext(this.handlers.get(i));
            curr = this.handlers.get(i);
        }
    }

    public static ErrorHandler getInstance() {
        return ErrorHandlerHolder.INSTANCE;
    }

    public Error process(String errorSring) {
        return this.chain.parseError(errorSring);
    }

    private static class ErrorHandlerHolder {
        private static final ErrorHandler INSTANCE = new ErrorHandler();

        private ErrorHandlerHolder() {
        }
    }
}

