/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.interceptor;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.exception.chain.ErrorHandler;
import io.github.lnyocly.ai4j.exception.error.Error;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ErrorInterceptor.class);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Response response = chain.proceed(original);
        byte[] contentBytes = response.body().bytes();
        String errorMsg = new String(contentBytes);
        if (!response.isSuccessful()) {
            try {
                JSONObject object = JSON.parseObject((String)errorMsg);
                if (object == null) {
                    errorMsg = response.code() + " " + response.message();
                    throw new CommonException(errorMsg);
                }
            }
            catch (Exception e) {
                throw new CommonException(errorMsg);
            }
            ErrorHandler errorHandler = ErrorHandler.getInstance();
            Error error = errorHandler.process(errorMsg);
            log.error("AI\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)error.getMessage());
            throw new CommonException(error.getMessage());
        }
        if (errorMsg.contains("Response") && errorMsg.contains("Error")) {
            ErrorHandler errorHandler = ErrorHandler.getInstance();
            Error error = errorHandler.process(errorMsg);
            log.error("AI\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)error.getMessage());
            throw new CommonException(error.getMessage());
        }
        ResponseBody newResponseBody = ResponseBody.create((MediaType)response.body().contentType(), (byte[])contentBytes);
        return response.newBuilder().body(newResponseBody).build();
    }
}

