/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.deepseek.chat.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.StreamOptions;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeepSeekChatCompletion {
    @NonNull
    private String model;
    @NonNull
    private List<ChatMessage> messages;
    @JsonProperty(value="frequency_penalty")
    private Float frequencyPenalty;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private Float presencePenalty;
    @JsonProperty(value="response_format")
    private Object responseFormat;
    private List<String> stop;
    private Boolean stream = false;
    @JsonProperty(value="stream_options")
    private StreamOptions streamOptions;
    private Float temperature;
    @JsonProperty(value="top_p")
    private Float topP;
    private List<Tool> tools;
    @JsonIgnore
    private List<String> functions;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    private Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    private Integer topLogprobs;

    private static Float $default$frequencyPenalty() {
        return Float.valueOf(0.0f);
    }

    private static Float $default$presencePenalty() {
        return Float.valueOf(0.0f);
    }

    private static StreamOptions $default$streamOptions() {
        return new StreamOptions();
    }

    private static Float $default$temperature() {
        return Float.valueOf(1.0f);
    }

    private static Float $default$topP() {
        return Float.valueOf(1.0f);
    }

    private static Boolean $default$logprobs() {
        return false;
    }

    public static DeepSeekChatCompletionBuilder builder() {
        return new DeepSeekChatCompletionBuilder();
    }

    public DeepSeekChatCompletionBuilder toBuilder() {
        return new DeepSeekChatCompletionBuilder().model(this.model).messages(this.messages).frequencyPenalty(this.frequencyPenalty).maxTokens(this.maxTokens).presencePenalty(this.presencePenalty).responseFormat(this.responseFormat).stop(this.stop).stream(this.stream).streamOptions(this.streamOptions).temperature(this.temperature).topP(this.topP).tools(this.tools).functions(this.functions).toolChoice(this.toolChoice).logprobs(this.logprobs).topLogprobs(this.topLogprobs);
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public Float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    public Object getResponseFormat() {
        return this.responseFormat;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public List<String> getFunctions() {
        return this.functions;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setMessages(@NonNull List<ChatMessage> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(Float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(Object responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    @JsonProperty(value="stream_options")
    public void setStreamOptions(StreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonIgnore
    public void setFunctions(List<String> functions) {
        this.functions = functions;
    }

    @JsonProperty(value="tool_choice")
    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    @JsonProperty(value="top_logprobs")
    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeepSeekChatCompletion)) {
            return false;
        }
        DeepSeekChatCompletion other = (DeepSeekChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$frequencyPenalty = this.getFrequencyPenalty();
        Float other$frequencyPenalty = other.getFrequencyPenalty();
        if (this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Float this$presencePenalty = this.getPresencePenalty();
        Float other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$topP = this.getTopP();
        Float other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Boolean this$logprobs = this.getLogprobs();
        Boolean other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        Integer this$topLogprobs = this.getTopLogprobs();
        Integer other$topLogprobs = other.getTopLogprobs();
        if (this$topLogprobs == null ? other$topLogprobs != null : !((Object)this$topLogprobs).equals(other$topLogprobs)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Object this$responseFormat = this.getResponseFormat();
        Object other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        StreamOptions this$streamOptions = this.getStreamOptions();
        StreamOptions other$streamOptions = other.getStreamOptions();
        if (this$streamOptions == null ? other$streamOptions != null : !((Object)this$streamOptions).equals(other$streamOptions)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        List<String> this$functions = this.getFunctions();
        List<String> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        String this$toolChoice = this.getToolChoice();
        String other$toolChoice = other.getToolChoice();
        return !(this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeepSeekChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Float $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Boolean $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        Integer $topLogprobs = this.getTopLogprobs();
        result = result * 59 + ($topLogprobs == null ? 43 : ((Object)$topLogprobs).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Object $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        StreamOptions $streamOptions = this.getStreamOptions();
        result = result * 59 + ($streamOptions == null ? 43 : ((Object)$streamOptions).hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        List<String> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        String $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        return result;
    }

    public String toString() {
        return "DeepSeekChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", responseFormat=" + this.getResponseFormat() + ", stop=" + this.getStop() + ", stream=" + this.getStream() + ", streamOptions=" + this.getStreamOptions() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", tools=" + this.getTools() + ", functions=" + this.getFunctions() + ", toolChoice=" + this.getToolChoice() + ", logprobs=" + this.getLogprobs() + ", topLogprobs=" + this.getTopLogprobs() + ")";
    }

    public DeepSeekChatCompletion() {
        this.frequencyPenalty = DeepSeekChatCompletion.$default$frequencyPenalty();
        this.presencePenalty = DeepSeekChatCompletion.$default$presencePenalty();
        this.streamOptions = DeepSeekChatCompletion.$default$streamOptions();
        this.temperature = DeepSeekChatCompletion.$default$temperature();
        this.topP = DeepSeekChatCompletion.$default$topP();
        this.logprobs = DeepSeekChatCompletion.$default$logprobs();
    }

    public DeepSeekChatCompletion(@NonNull String model, @NonNull List<ChatMessage> messages, Float frequencyPenalty, Integer maxTokens, Float presencePenalty, Object responseFormat, List<String> stop, Boolean stream, StreamOptions streamOptions, Float temperature, Float topP, List<Tool> tools, List<String> functions, String toolChoice, Boolean logprobs, Integer topLogprobs) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.frequencyPenalty = frequencyPenalty;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.responseFormat = responseFormat;
        this.stop = stop;
        this.stream = stream;
        this.streamOptions = streamOptions;
        this.temperature = temperature;
        this.topP = topP;
        this.tools = tools;
        this.functions = functions;
        this.toolChoice = toolChoice;
        this.logprobs = logprobs;
        this.topLogprobs = topLogprobs;
    }

    public static class DeepSeekChatCompletionBuilder {
        private String model;
        private List<ChatMessage> messages;
        private boolean frequencyPenalty$set;
        private Float frequencyPenalty$value;
        private Integer maxTokens;
        private boolean presencePenalty$set;
        private Float presencePenalty$value;
        private Object responseFormat;
        private List<String> stop;
        private Boolean stream;
        private boolean streamOptions$set;
        private StreamOptions streamOptions$value;
        private boolean temperature$set;
        private Float temperature$value;
        private boolean topP$set;
        private Float topP$value;
        private List<Tool> tools;
        private String toolChoice;
        private boolean logprobs$set;
        private Boolean logprobs$value;
        private Integer topLogprobs;
        private List<String> functions;

        public DeepSeekChatCompletionBuilder functions(String ... functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<String>();
            }
            this.functions.addAll(Arrays.asList(functions));
            return this;
        }

        public DeepSeekChatCompletionBuilder functions(List<String> functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<String>();
            }
            this.functions.addAll(functions);
            return this;
        }

        DeepSeekChatCompletionBuilder() {
        }

        public DeepSeekChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public DeepSeekChatCompletionBuilder messages(@NonNull List<ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public DeepSeekChatCompletionBuilder frequencyPenalty(Float frequencyPenalty) {
            this.frequencyPenalty$value = frequencyPenalty;
            this.frequencyPenalty$set = true;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public DeepSeekChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public DeepSeekChatCompletionBuilder presencePenalty(Float presencePenalty) {
            this.presencePenalty$value = presencePenalty;
            this.presencePenalty$set = true;
            return this;
        }

        @JsonProperty(value="response_format")
        public DeepSeekChatCompletionBuilder responseFormat(Object responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public DeepSeekChatCompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public DeepSeekChatCompletionBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @JsonProperty(value="stream_options")
        public DeepSeekChatCompletionBuilder streamOptions(StreamOptions streamOptions) {
            this.streamOptions$value = streamOptions;
            this.streamOptions$set = true;
            return this;
        }

        public DeepSeekChatCompletionBuilder temperature(Float temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public DeepSeekChatCompletionBuilder topP(Float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public DeepSeekChatCompletionBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonProperty(value="tool_choice")
        public DeepSeekChatCompletionBuilder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public DeepSeekChatCompletionBuilder logprobs(Boolean logprobs) {
            this.logprobs$value = logprobs;
            this.logprobs$set = true;
            return this;
        }

        @JsonProperty(value="top_logprobs")
        public DeepSeekChatCompletionBuilder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public DeepSeekChatCompletion build() {
            Float frequencyPenalty$value = this.frequencyPenalty$value;
            if (!this.frequencyPenalty$set) {
                frequencyPenalty$value = DeepSeekChatCompletion.$default$frequencyPenalty();
            }
            Float presencePenalty$value = this.presencePenalty$value;
            if (!this.presencePenalty$set) {
                presencePenalty$value = DeepSeekChatCompletion.$default$presencePenalty();
            }
            StreamOptions streamOptions$value = this.streamOptions$value;
            if (!this.streamOptions$set) {
                streamOptions$value = DeepSeekChatCompletion.$default$streamOptions();
            }
            Float temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = DeepSeekChatCompletion.$default$temperature();
            }
            Float topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = DeepSeekChatCompletion.$default$topP();
            }
            Boolean logprobs$value = this.logprobs$value;
            if (!this.logprobs$set) {
                logprobs$value = DeepSeekChatCompletion.$default$logprobs();
            }
            return new DeepSeekChatCompletion(this.model, this.messages, frequencyPenalty$value, this.maxTokens, presencePenalty$value, this.responseFormat, this.stop, this.stream, streamOptions$value, temperature$value, topP$value, this.tools, this.functions, this.toolChoice, logprobs$value, this.topLogprobs);
        }

        public String toString() {
            return "DeepSeekChatCompletion.DeepSeekChatCompletionBuilder(model=" + this.model + ", messages=" + this.messages + ", frequencyPenalty$value=" + this.frequencyPenalty$value + ", maxTokens=" + this.maxTokens + ", presencePenalty$value=" + this.presencePenalty$value + ", responseFormat=" + this.responseFormat + ", stop=" + this.stop + ", stream=" + this.stream + ", streamOptions$value=" + this.streamOptions$value + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", tools=" + this.tools + ", functions=" + this.functions + ", toolChoice=" + this.toolChoice + ", logprobs$value=" + this.logprobs$value + ", topLogprobs=" + this.topLogprobs + ")";
        }
    }
}

