/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.hunyuan.chat;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import io.github.lnyocly.ai4j.config.HunyuanConfig;
import io.github.lnyocly.ai4j.convert.chat.ParameterConvert;
import io.github.lnyocly.ai4j.convert.chat.ResultConvert;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.hunyuan.chat.entity.HunyuanChatCompletion;
import io.github.lnyocly.ai4j.platform.hunyuan.chat.entity.HunyuanChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.BearerTokenUtils;
import io.github.lnyocly.ai4j.utils.JsonObjectUtil;
import io.github.lnyocly.ai4j.utils.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunyuanChatService
implements IChatService,
ParameterConvert<HunyuanChatCompletion>,
ResultConvert<HunyuanChatCompletionResponse> {
    private final HunyuanConfig hunyuanConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public HunyuanChatService(Configuration configuration) {
        this.hunyuanConfig = configuration.getHunyuanConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public HunyuanChatCompletion convertChatCompletionObject(ChatCompletion chatCompletion) {
        HunyuanChatCompletion hunyuanChatCompletion = new HunyuanChatCompletion();
        hunyuanChatCompletion.setModel(chatCompletion.getModel());
        hunyuanChatCompletion.setMessages(chatCompletion.getMessages());
        hunyuanChatCompletion.setStream(chatCompletion.getStream());
        hunyuanChatCompletion.setTemperature(chatCompletion.getTemperature());
        hunyuanChatCompletion.setTopP(chatCompletion.getTopP());
        hunyuanChatCompletion.setTools(chatCompletion.getTools());
        hunyuanChatCompletion.setFunctions(chatCompletion.getFunctions());
        hunyuanChatCompletion.setToolChoice(chatCompletion.getToolChoice());
        return hunyuanChatCompletion;
    }

    @Override
    public EventSourceListener convertEventSource(final SseListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    eventSourceListener.onEvent(eventSource, id, type, data);
                    return;
                }
                HunyuanChatCompletionResponse hunyuanChatCompletionResponse = (HunyuanChatCompletionResponse)JSON.parseObject((String)JsonObjectUtil.toSnakeCaseJson(data), HunyuanChatCompletionResponse.class);
                ChatCompletionResponse response = HunyuanChatService.this.convertChatCompletionResponse(hunyuanChatCompletionResponse);
                response.setObject("chat.completion.chunk");
                Choice choice = response.getChoices().get(0);
                if (eventSourceListener.getToolCall() != null && choice.getDelta().getToolCalls() != null) {
                    choice.getDelta().getToolCalls().get(0).setId(null);
                }
                if (StringUtils.isBlank((CharSequence)choice.getFinishReason())) {
                    response.setUsage(null);
                }
                if ("tool_calls".equals(choice.getFinishReason())) {
                    // empty if block
                }
                eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)response));
            }

            public void onClosed(@NotNull EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }
        };
    }

    @Override
    public ChatCompletionResponse convertChatCompletionResponse(HunyuanChatCompletionResponse hunyuanChatCompletionResponse) {
        ChatCompletionResponse chatCompletionResponse = new ChatCompletionResponse();
        chatCompletionResponse.setId(hunyuanChatCompletionResponse.getId());
        chatCompletionResponse.setObject(hunyuanChatCompletionResponse.getObject());
        chatCompletionResponse.setCreated(Long.valueOf(hunyuanChatCompletionResponse.getCreated()));
        chatCompletionResponse.setModel(hunyuanChatCompletionResponse.getModel());
        chatCompletionResponse.setChoices(hunyuanChatCompletionResponse.getChoices());
        chatCompletionResponse.setUsage(hunyuanChatCompletionResponse.getUsage());
        return chatCompletionResponse;
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.hunyuanConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.hunyuanConfig.getApiKey();
        }
        chatCompletion.setStream(false);
        HunyuanChatCompletion hunyuanChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (hunyuanChatCompletion.getFunctions() != null && !hunyuanChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(hunyuanChatCompletion.getFunctions());
            hunyuanChatCompletion.setTools(tools);
        }
        Usage allUsage = new Usage();
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            JSONArray messagesArray;
            finishReason = null;
            String requestString = JSON.toJSONString((Object)hunyuanChatCompletion);
            JSONObject jsonObject = JSON.parseObject((String)requestString);
            JSONArray toolsArray = jsonObject.getJSONArray("tools");
            if (toolsArray != null && !toolsArray.isEmpty()) {
                for (int i = 0; i < toolsArray.size(); ++i) {
                    JSONObject tool = toolsArray.getJSONObject(i);
                    JSONObject function = tool.getJSONObject("function");
                    JSONObject newFunction = new JSONObject();
                    newFunction.put((Object)"name", (Object)function.getString("name"));
                    newFunction.put((Object)"description", (Object)function.getString("description"));
                    newFunction.put((Object)"parameters", (Object)function.getJSONObject("parameters").toJSONString(new JSONWriter.Feature[0]));
                    tool.put((Object)"function", (Object)newFunction);
                    tool.put((Object)"type", (Object)"function");
                }
            }
            if ("hunyuan-vision".equals(chatCompletion.getModel()) && (messagesArray = jsonObject.getJSONArray("messages")) != null && !messagesArray.isEmpty()) {
                for (int i = 0; i < messagesArray.size(); ++i) {
                    List multiModals;
                    JSONObject message = messagesArray.getJSONObject(i);
                    String content = message.getString("content");
                    if (content == null || !content.startsWith("[") || !content.endsWith("]") || (multiModals = JSON.parseArray((String)content, ChatMessage.MultiModal.class)) == null || multiModals.isEmpty()) continue;
                    message.put((Object)"contents", (Object)multiModals);
                    message.remove((Object)"content");
                }
            }
            requestString = jsonObject.toJSONString(new JSONWriter.Feature[0]);
            String authorization = BearerTokenUtils.getAuthorization(apiKey, "ChatCompletions", requestString = JsonObjectUtil.toCamelCaseWithUppercaseJson(requestString));
            Request request = new Request.Builder().header("Authorization", authorization).header("X-TC-Action", "ChatCompletions").header("X-TC-Version", "2023-09-01").header("X-TC-Timestamp", String.valueOf(System.currentTimeMillis() / 1000L)).url(baseUrl).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString)).build();
            Response execute = this.okHttpClient.newCall(request).execute();
            if (!execute.isSuccessful() || execute.body() == null) continue;
            String responseString = execute.body().string();
            responseString = JsonObjectUtil.toSnakeCaseJson(responseString);
            responseString = JSON.parseObject((String)responseString).get("response").toString();
            HunyuanChatCompletionResponse hunyuanChatCompletionResponse = (HunyuanChatCompletionResponse)JSON.parseObject((String)responseString, HunyuanChatCompletionResponse.class);
            Choice choice = hunyuanChatCompletionResponse.getChoices().get(0);
            finishReason = choice.getFinishReason();
            Usage usage = hunyuanChatCompletionResponse.getUsage();
            allUsage.setCompletionTokens(allUsage.getCompletionTokens() + usage.getCompletionTokens());
            allUsage.setTotalTokens(allUsage.getTotalTokens() + usage.getTotalTokens());
            allUsage.setPromptTokens(allUsage.getPromptTokens() + usage.getPromptTokens());
            if ("tool_calls".equals(finishReason)) {
                ChatMessage message = choice.getMessage();
                List<ToolCall> toolCalls = message.getToolCalls();
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(hunyuanChatCompletion.getMessages());
                messages.add(message);
                for (ToolCall toolCall : toolCalls) {
                    String functionName = toolCall.getFunction().getName();
                    String arguments = toolCall.getFunction().getArguments();
                    String functionResponse = ToolUtil.invoke(functionName, arguments);
                    messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
                }
                hunyuanChatCompletion.setMessages(messages);
                continue;
            }
            hunyuanChatCompletionResponse.setUsage(allUsage);
            hunyuanChatCompletionResponse.setObject("chat.completion");
            hunyuanChatCompletionResponse.setModel(hunyuanChatCompletion.getModel());
            chatCompletion.setMessages(hunyuanChatCompletion.getMessages());
            chatCompletion.setTools(hunyuanChatCompletion.getTools());
            return this.convertChatCompletionResponse(hunyuanChatCompletionResponse);
        }
        return null;
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatCompletion(null, null, chatCompletion);
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.hunyuanConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.hunyuanConfig.getApiKey();
        }
        chatCompletion.setStream(true);
        HunyuanChatCompletion hunyuanChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (hunyuanChatCompletion.getFunctions() != null && !hunyuanChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(hunyuanChatCompletion.getFunctions());
            hunyuanChatCompletion.setTools(tools);
        }
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            JSONArray messagesArray;
            finishReason = null;
            String requestString = JSON.toJSONString((Object)hunyuanChatCompletion);
            JSONObject jsonObject = JSON.parseObject((String)requestString);
            JSONArray toolsArray = jsonObject.getJSONArray("tools");
            if (toolsArray != null && !toolsArray.isEmpty()) {
                for (int i = 0; i < toolsArray.size(); ++i) {
                    JSONObject tool = toolsArray.getJSONObject(i);
                    JSONObject function = tool.getJSONObject("function");
                    JSONObject newFunction = new JSONObject();
                    newFunction.put((Object)"name", (Object)function.getString("name"));
                    newFunction.put((Object)"description", (Object)function.getString("description"));
                    newFunction.put((Object)"parameters", (Object)function.getJSONObject("parameters").toJSONString(new JSONWriter.Feature[0]));
                    tool.put((Object)"function", (Object)newFunction);
                    tool.put((Object)"type", (Object)"function");
                }
            }
            if ("hunyuan-vision".equals(chatCompletion.getModel()) && (messagesArray = jsonObject.getJSONArray("messages")) != null && !messagesArray.isEmpty()) {
                for (int i = 0; i < messagesArray.size(); ++i) {
                    List multiModals;
                    JSONObject message = messagesArray.getJSONObject(i);
                    String content = message.getString("content");
                    if (content == null || !content.startsWith("[") || !content.endsWith("]") || (multiModals = JSON.parseArray((String)content, ChatMessage.MultiModal.class)) == null || multiModals.isEmpty()) continue;
                    message.put((Object)"contents", (Object)multiModals);
                    message.remove((Object)"content");
                }
            }
            requestString = jsonObject.toJSONString(new JSONWriter.Feature[0]);
            requestString = JsonObjectUtil.toCamelCaseWithUppercaseJson(requestString);
            String authorization = BearerTokenUtils.getAuthorization(apiKey, "ChatCompletions", requestString);
            Request request = new Request.Builder().header("Authorization", authorization).header("X-TC-Action", "ChatCompletions").header("X-TC-Version", "2023-09-01").header("X-TC-Timestamp", String.valueOf(System.currentTimeMillis() / 1000L)).header("Accept", "text/event-stream").url(baseUrl).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestString)).build();
            this.factory.newEventSource(request, this.convertEventSource(eventSourceListener));
            eventSourceListener.getCountDownLatch().await();
            finishReason = eventSourceListener.getFinishReason();
            List<ToolCall> toolCalls = eventSourceListener.getToolCalls();
            if (!"tool_calls".equals(finishReason) || toolCalls.isEmpty()) continue;
            ChatMessage responseMessage = ChatMessage.withAssistant(eventSourceListener.getToolCalls());
            responseMessage.setContent(" ");
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(hunyuanChatCompletion.getMessages());
            messages.add(responseMessage);
            for (ToolCall toolCall : toolCalls) {
                String functionName = toolCall.getFunction().getName();
                String arguments = toolCall.getFunction().getArguments();
                String functionResponse = ToolUtil.invoke(functionName, arguments);
                messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
            }
            eventSourceListener.setToolCalls(new ArrayList<ToolCall>());
            eventSourceListener.setToolCall(null);
            hunyuanChatCompletion.setMessages(messages);
        }
        chatCompletion.setMessages(hunyuanChatCompletion.getMessages());
        chatCompletion.setTools(hunyuanChatCompletion.getTools());
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatCompletionStream(null, null, chatCompletion, eventSourceListener);
    }
}

