/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.audio.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.audio.enums.AudioEnum;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TextToSpeech {
    @NonNull
    private String model;
    @NonNull
    private String input;
    @NonNull
    private String voice;
    @JsonProperty(value="response_format")
    private String responseFormat;
    private Double speed;

    private static String $default$model() {
        return "tts-1";
    }

    private static String $default$voice() {
        return AudioEnum.Voice.ALLOY.getValue();
    }

    private static String $default$responseFormat() {
        return AudioEnum.ResponseFormat.MP3.getValue();
    }

    private static Double $default$speed() {
        return 1.0;
    }

    public static TextToSpeechBuilder builder() {
        return new TextToSpeechBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getInput() {
        return this.input;
    }

    @NonNull
    public String getVoice() {
        return this.voice;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setInput(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
    }

    public void setVoice(@NonNull String voice) {
        if (voice == null) {
            throw new NullPointerException("voice is marked non-null but is null");
        }
        this.voice = voice;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextToSpeech)) {
            return false;
        }
        TextToSpeech other = (TextToSpeech)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$speed = this.getSpeed();
        Double other$speed = other.getSpeed();
        if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        String this$voice = this.getVoice();
        String other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !this$voice.equals(other$voice)) {
            return false;
        }
        String this$responseFormat = this.getResponseFormat();
        String other$responseFormat = other.getResponseFormat();
        return !(this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextToSpeech;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $speed = this.getSpeed();
        result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        String $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : $voice.hashCode());
        String $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        return result;
    }

    public String toString() {
        return "TextToSpeech(model=" + this.getModel() + ", input=" + this.getInput() + ", voice=" + this.getVoice() + ", responseFormat=" + this.getResponseFormat() + ", speed=" + this.getSpeed() + ")";
    }

    public TextToSpeech(@NonNull String model, @NonNull String input, @NonNull String voice, String responseFormat, Double speed) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (voice == null) {
            throw new NullPointerException("voice is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.voice = voice;
        this.responseFormat = responseFormat;
        this.speed = speed;
    }

    public TextToSpeech() {
        this.model = TextToSpeech.$default$model();
        this.voice = TextToSpeech.$default$voice();
        this.responseFormat = TextToSpeech.$default$responseFormat();
        this.speed = TextToSpeech.$default$speed();
    }

    public static class TextToSpeechBuilder {
        private boolean model$set;
        private String model$value;
        private String input;
        private boolean voice$set;
        private String voice$value;
        private boolean responseFormat$set;
        private String responseFormat$value;
        private boolean speed$set;
        private Double speed$value;

        TextToSpeechBuilder() {
        }

        public TextToSpeechBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public TextToSpeechBuilder input(@NonNull String input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public TextToSpeechBuilder voice(@NonNull String voice) {
            if (voice == null) {
                throw new NullPointerException("voice is marked non-null but is null");
            }
            this.voice$value = voice;
            this.voice$set = true;
            return this;
        }

        @JsonProperty(value="response_format")
        public TextToSpeechBuilder responseFormat(String responseFormat) {
            this.responseFormat$value = responseFormat;
            this.responseFormat$set = true;
            return this;
        }

        public TextToSpeechBuilder speed(Double speed) {
            this.speed$value = speed;
            this.speed$set = true;
            return this;
        }

        public TextToSpeech build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = TextToSpeech.$default$model();
            }
            String voice$value = this.voice$value;
            if (!this.voice$set) {
                voice$value = TextToSpeech.$default$voice();
            }
            String responseFormat$value = this.responseFormat$value;
            if (!this.responseFormat$set) {
                responseFormat$value = TextToSpeech.$default$responseFormat();
            }
            Double speed$value = this.speed$value;
            if (!this.speed$set) {
                speed$value = TextToSpeech.$default$speed();
            }
            return new TextToSpeech(model$value, this.input, voice$value, responseFormat$value, speed$value);
        }

        public String toString() {
            return "TextToSpeech.TextToSpeechBuilder(model$value=" + this.model$value + ", input=" + this.input + ", voice$value=" + this.voice$value + ", responseFormat$value=" + this.responseFormat$value + ", speed$value=" + this.speed$value + ")";
        }
    }
}

