/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class BearerTokenUtils {
    private static final long EXPIRE_MILLIS = 86400000L;
    public static Cache<String, String> cache = CacheBuilder.newBuilder().initialCapacity(100).expireAfterWrite(86340000L, TimeUnit.MILLISECONDS).build();

    public static String getToken(String apiKey) {
        String[] args = apiKey.split("\\.");
        if (args.length != 2) {
            throw new IllegalArgumentException("API Key \u683c\u5f0f\u9519\u8bef");
        }
        String id = args[0];
        String secret = args[1];
        String token = (String)cache.getIfPresent((Object)apiKey);
        if (null != token) {
            return token;
        }
        Algorithm algorithm = Algorithm.HMAC256((byte[])secret.getBytes(StandardCharsets.UTF_8));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("api_key", id);
        payload.put("exp", System.currentTimeMillis() + 86400000L);
        payload.put("timestamp", System.currentTimeMillis());
        HashMap<String, String> headerClaims = new HashMap<String, String>();
        headerClaims.put("alg", "HS256");
        headerClaims.put("sign_type", "SIGN");
        token = JWT.create().withPayload(payload).withHeader(headerClaims).sign(algorithm);
        cache.put((Object)id, (Object)token);
        return token;
    }

    public static String getAuthorization(String apiKey, String action, String payloadJson) throws Exception {
        String[] args = apiKey.split("\\.");
        if (args.length != 2) {
            throw new IllegalArgumentException("API Key \u683c\u5f0f\u9519\u8bef");
        }
        String id = args[0];
        String key = args[1];
        String algorithm = "TC3-HMAC-SHA256";
        String service = "hunyuan";
        String host = "hunyuan.tencentcloudapi.com";
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date(Long.valueOf(timestamp + "000")));
        String httpRequestMethod = "POST";
        String canonicalUri = "/";
        String canonicalQueryString = "";
        String canonicalHeaders = "content-type:application/json; charset=utf-8\nhost:" + host + "\nx-tc-action:" + action.toLowerCase() + "\n";
        String signedHeaders = "content-type;host;x-tc-action";
        String hashedRequestPayload = BearerTokenUtils.sha256Hex(payloadJson);
        String canonicalRequest = httpRequestMethod + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
        String credentialScope = date + "/" + service + "/tc3_request";
        String hashedCanonicalRequest = BearerTokenUtils.sha256Hex(canonicalRequest);
        String stringToSign = algorithm + "\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
        byte[] secretDate = BearerTokenUtils.hmac256(("TC3" + key).getBytes(StandardCharsets.UTF_8), date);
        byte[] secretService = BearerTokenUtils.hmac256(secretDate, service);
        byte[] secretSigning = BearerTokenUtils.hmac256(secretService, "tc3_request");
        String signature = DatatypeConverter.printHexBinary((byte[])BearerTokenUtils.hmac256(secretSigning, stringToSign)).toLowerCase();
        String authorization = algorithm + " Credential=" + id + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        return authorization;
    }

    private static byte[] hmac256(byte[] key, String msg) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
    }

    private static String sha256Hex(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] d = md.digest(s.getBytes(StandardCharsets.UTF_8));
        return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
    }
}

