/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaUtil {
    private static final Tika tika = new Tika();

    public static String parseFile(File file) throws IOException, TikaException, SAXException {
        try (InputStream stream = file.toURI().toURL().openStream();){
            String string = TikaUtil.parseInputStream(stream);
            return string;
        }
    }

    public static String parseInputStream(InputStream stream) throws IOException, TikaException, SAXException {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        AutoDetectParser parser = new AutoDetectParser();
        ParseContext context = new ParseContext();
        parser.parse(stream, (ContentHandler)handler, metadata, context);
        return handler.toString();
    }

    public static String parseFileWithTika(File file) throws IOException, TikaException {
        return tika.parseToString(file);
    }

    public static String parseInputStreamWithTika(InputStream stream) throws IOException, TikaException {
        return tika.parseToString(stream);
    }

    public static String detectMimeType(File file) throws IOException {
        return tika.detect(file);
    }

    public static String detectMimeType(InputStream stream) throws IOException {
        return tika.detect(stream);
    }
}

