/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.configuration;

import com.mzt.logapi.service.IFunctionService;
import com.mzt.logapi.service.ILogRecordPerformanceMonitor;
import com.mzt.logapi.service.ILogRecordService;
import com.mzt.logapi.service.IOperatorGetService;
import com.mzt.logapi.service.IParseFunction;
import com.mzt.logapi.service.impl.DefaultFunctionServiceImpl;
import com.mzt.logapi.service.impl.DefaultLogRecordPerformanceMonitor;
import com.mzt.logapi.service.impl.DefaultLogRecordServiceImpl;
import com.mzt.logapi.service.impl.DefaultOperatorGetServiceImpl;
import com.mzt.logapi.service.impl.DefaultParseFunction;
import com.mzt.logapi.service.impl.DiffParseFunction;
import com.mzt.logapi.service.impl.ParseFunctionFactory;
import com.mzt.logapi.starter.annotation.EnableLogRecord;
import com.mzt.logapi.starter.configuration.LogRecordProperties;
import com.mzt.logapi.starter.diff.DefaultDiffItemsToLogContentService;
import com.mzt.logapi.starter.diff.IDiffItemsToLogContentService;
import com.mzt.logapi.starter.support.aop.BeanFactoryLogRecordAdvisor;
import com.mzt.logapi.starter.support.aop.LogRecordInterceptor;
import com.mzt.logapi.starter.support.aop.LogRecordOperationSource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={LogRecordProperties.class})
public class LogRecordProxyAutoConfiguration
implements ImportAware {
    private static final Logger log = LoggerFactory.getLogger(LogRecordProxyAutoConfiguration.class);
    private AnnotationAttributes enableLogRecord;

    @Bean
    @Role(value=2)
    public LogRecordOperationSource logRecordOperationSource() {
        return new LogRecordOperationSource();
    }

    @Bean
    @ConditionalOnMissingBean(value={IFunctionService.class})
    public IFunctionService functionService(ParseFunctionFactory parseFunctionFactory) {
        return new DefaultFunctionServiceImpl(parseFunctionFactory);
    }

    @Bean
    public ParseFunctionFactory parseFunctionFactory(@Autowired List<IParseFunction> parseFunctions) {
        return new ParseFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(value={IParseFunction.class})
    public DefaultParseFunction parseFunction() {
        return new DefaultParseFunction();
    }

    @Bean
    @Role(value=2)
    public BeanFactoryLogRecordAdvisor logRecordAdvisor(LogRecordProperties logRecordProperties) {
        BeanFactoryLogRecordAdvisor advisor = new BeanFactoryLogRecordAdvisor();
        advisor.setLogRecordOperationSource(this.logRecordOperationSource());
        advisor.setAdvice((Advice)this.logRecordInterceptor(logRecordProperties.getDiffLog()));
        advisor.setOrder((Integer)this.enableLogRecord.getNumber("order"));
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean(value={ILogRecordPerformanceMonitor.class})
    public ILogRecordPerformanceMonitor logRecordPerformanceMonitor() {
        return new DefaultLogRecordPerformanceMonitor();
    }

    @Bean
    @Role(value=2)
    public LogRecordInterceptor logRecordInterceptor(Boolean diffLog) {
        LogRecordInterceptor interceptor = new LogRecordInterceptor();
        interceptor.setLogRecordOperationSource(this.logRecordOperationSource());
        interceptor.setTenant(this.enableLogRecord.getString("tenant"));
        interceptor.setJoinTransaction(this.enableLogRecord.getBoolean("joinTransaction"));
        interceptor.setDiffLog(diffLog);
        interceptor.setLogRecordPerformanceMonitor(this.logRecordPerformanceMonitor());
        return interceptor;
    }

    @Bean
    public DiffParseFunction diffParseFunction(IDiffItemsToLogContentService diffItemsToLogContentService, LogRecordProperties logRecordProperties) {
        DiffParseFunction diffParseFunction = new DiffParseFunction();
        diffParseFunction.setDiffItemsToLogContentService(diffItemsToLogContentService);
        diffParseFunction.addUseEqualsClass(LocalDateTime.class);
        if (!StringUtils.isEmpty((Object)logRecordProperties.getUseEqualsMethod())) {
            diffParseFunction.addUseEqualsClass(Arrays.asList(logRecordProperties.getUseEqualsMethod().split(",")));
        }
        return diffParseFunction;
    }

    @Bean
    @ConditionalOnMissingBean(value={IDiffItemsToLogContentService.class})
    @Role(value=0)
    public IDiffItemsToLogContentService diffItemsToLogContentService(LogRecordProperties logRecordProperties) {
        return new DefaultDiffItemsToLogContentService(logRecordProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={IOperatorGetService.class})
    @Role(value=0)
    public IOperatorGetService operatorGetService() {
        return new DefaultOperatorGetServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={ILogRecordService.class})
    @Role(value=0)
    public ILogRecordService recordService() {
        return new DefaultLogRecordServiceImpl();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLogRecord = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableLogRecord.class.getName(), false));
        if (this.enableLogRecord == null) {
            log.info("EnableLogRecord is not present on importing class");
        }
    }
}

