/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.util.diff;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.TypeAwareAccessor;
import de.danielbechler.diff.identity.EqualsIdentityStrategy;
import de.danielbechler.diff.identity.IdentityStrategy;
import de.danielbechler.diff.selector.CollectionItemElementSelector;
import de.danielbechler.diff.selector.ElementSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.util.Assert;

public class ArrayItemAccessor
implements TypeAwareAccessor,
Accessor {
    private final Object referenceItem;
    private final IdentityStrategy identityStrategy;

    public ArrayItemAccessor(Object referenceItem) {
        this(referenceItem, (IdentityStrategy)EqualsIdentityStrategy.getInstance());
    }

    public ArrayItemAccessor(Object referenceItem, IdentityStrategy identityStrategy) {
        Assert.notNull((Object)identityStrategy, (String)"identityStrategy");
        this.referenceItem = referenceItem;
        this.identityStrategy = identityStrategy;
    }

    public Class<?> getType() {
        return this.referenceItem != null ? this.referenceItem.getClass() : null;
    }

    public String toString() {
        return "collection item " + this.getElementSelector();
    }

    public ElementSelector getElementSelector() {
        CollectionItemElementSelector selector = new CollectionItemElementSelector(this.referenceItem);
        return this.identityStrategy == null ? selector : selector.copyWithIdentityStrategy(this.identityStrategy);
    }

    public Object get(Object target) {
        Collection<Object> targetCollection = ArrayItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return null;
        }
        for (Object item : targetCollection) {
            if (item == null || !this.identityStrategy.equals(item, this.referenceItem)) continue;
            return item;
        }
        return null;
    }

    public void set(Object target, Object value) {
        Collection<Object> targetCollection = ArrayItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return;
        }
        Object previous = this.get(target);
        if (previous != null) {
            this.unset(target);
        }
        targetCollection.add(value);
    }

    private static Collection<Object> objectAsCollection(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])object));
        }
        throw new IllegalArgumentException(object.getClass().toString());
    }

    public void unset(Object target) {
        Collection<Object> targetCollection = ArrayItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return;
        }
        Iterator<Object> iterator = targetCollection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (item == null || !this.identityStrategy.equals(item, this.referenceItem)) continue;
            iterator.remove();
            break;
        }
    }
}

