/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller;

import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth/permissions"})
public class PermissionController {
    @Autowired
    private NacosRoleServiceImpl nacosRoleService;

    @GetMapping(params={"search=accurate"})
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    public Object getPermissions(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="role", defaultValue="") String role) {
        return this.nacosRoleService.getPermissionsFromDatabase(role, pageNo, pageSize);
    }

    @GetMapping(params={"search=blur"})
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    public Page<PermissionInfo> fuzzySearchPermission(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="role", defaultValue="") String role) {
        return this.nacosRoleService.findPermissionsLike4Page(role, pageNo, pageSize);
    }

    @PostMapping
    @Secured(resource="console/permissions", action=ActionTypes.WRITE)
    public Object addPermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        this.nacosRoleService.addPermission(role, resource, action);
        return RestResultUtils.success((Object)"add permission ok!");
    }

    @DeleteMapping
    @Secured(resource="console/permissions", action=ActionTypes.WRITE)
    public Object deletePermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        this.nacosRoleService.deletePermission(role, resource, action);
        return RestResultUtils.success((Object)"delete permission ok!");
    }

    @GetMapping
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    public Result<Boolean> isDuplicatePermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        return this.nacosRoleService.isDuplicatePermission(role, resource, action);
    }
}

