/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.address;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.address.ServerListProvider;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public abstract class AbstractServerListManager
implements ServerListFactory,
Closeable {
    private static final Logger LOGGER = LogUtils.logger(AbstractServerListManager.class);
    protected ServerListProvider serverListProvider;
    protected NacosClientProperties properties;

    public AbstractServerListManager(NacosClientProperties properties) {
        this(properties, null);
    }

    public AbstractServerListManager(NacosClientProperties properties, String namespace) {
        NacosClientProperties tmpProperties = properties.derive();
        if (StringUtils.isNotBlank((String)namespace)) {
            tmpProperties.setProperty("namespace", namespace);
        }
        tmpProperties.setProperty("clientModuleType", this.getModuleName());
        this.properties = tmpProperties;
    }

    public List<String> getServerList() {
        return this.serverListProvider.getServerList();
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        if (null != this.serverListProvider) {
            this.serverListProvider.shutdown();
        }
        this.serverListProvider = null;
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    public void start() throws NacosException {
        Collection serverListProviders = NacosServiceLoader.load(ServerListProvider.class);
        Collection sorted = serverListProviders.stream().sorted((a, b) -> b.getOrder() - a.getOrder()).collect(Collectors.toList());
        for (ServerListProvider each : sorted) {
            boolean matchResult = each.match(this.properties);
            LOGGER.info("Load and match ServerListProvider {}, match result: {}", (Object)each.getClass().getCanonicalName(), (Object)matchResult);
            if (!matchResult) continue;
            this.serverListProvider = each;
            LOGGER.info("Will use {} as ServerListProvider", (Object)this.serverListProvider.getClass().getCanonicalName());
            break;
        }
        if (null == this.serverListProvider) {
            LOGGER.error("No server list provider found, SPI load size: {}", (Object)sorted.size());
            throw new NacosException(-400, "No server list provider found.");
        }
        this.serverListProvider.init(this.properties, this.getNacosRestTemplate());
    }

    public String getServerName() {
        return this.getModuleName() + "-" + this.serverListProvider.getServerName();
    }

    public String getContextPath() {
        return this.serverListProvider.getContextPath();
    }

    public String getNamespace() {
        return this.serverListProvider.getNamespace();
    }

    public String getAddressSource() {
        return this.serverListProvider.getAddressSource();
    }

    public boolean isFixed() {
        return this.serverListProvider.isFixed();
    }

    protected abstract String getModuleName();

    protected abstract NacosRestTemplate getNacosRestTemplate();

    @JustForTest
    NacosClientProperties getProperties() {
        return this.properties;
    }
}

