/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.logging.NacosLoggingAdapter;
import com.alibaba.nacos.common.logging.NacosLoggingAdapterBuilder;
import com.alibaba.nacos.common.logging.NacosLoggingProperties;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosLogging.class);
    private NacosLoggingAdapter loggingAdapter;
    private NacosLoggingProperties loggingProperties;

    private NacosLogging() {
        this.initLoggingAdapter();
    }

    private void initLoggingAdapter() {
        Class loggerClass = LOGGER.getClass();
        for (NacosLoggingAdapterBuilder each : NacosServiceLoader.load(NacosLoggingAdapterBuilder.class)) {
            LOGGER.info("Nacos Logging Adapter Builder: {}", (Object)each.getClass().getName());
            NacosLoggingAdapter tempLoggingAdapter = this.buildLoggingAdapterFromBuilder(each);
            if (!this.isAdaptLogging(tempLoggingAdapter, loggerClass)) continue;
            LOGGER.info("Nacos Logging Adapter: {} match {} success.", (Object)tempLoggingAdapter.getClass().getName(), (Object)loggerClass.getName());
            this.loggingProperties = new NacosLoggingProperties(tempLoggingAdapter.getDefaultConfigLocation(), NacosClientProperties.PROTOTYPE.asProperties());
            this.loggingAdapter = tempLoggingAdapter;
        }
        if (null == this.loggingAdapter) {
            LOGGER.warn("Nacos Logging don't find adapter, logging will print into application logs.");
            return;
        }
        this.scheduleReloadTask();
    }

    private NacosLoggingAdapter buildLoggingAdapterFromBuilder(NacosLoggingAdapterBuilder builder) {
        try {
            return builder.build();
        }
        catch (Throwable e) {
            LOGGER.warn("Build Nacos Logging Adapter failed: {}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean isAdaptLogging(NacosLoggingAdapter loggingAdapter, Class<? extends Logger> loggerClass) {
        return null != loggingAdapter && loggingAdapter.isEnabled() && loggingAdapter.isAdaptedLogger(loggerClass);
    }

    private void scheduleReloadTask() {
        ScheduledExecutorService reloadContextService = ExecutorFactory.Managed.newSingleScheduledExecutorService((String)"Nacos-Client", (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.logging"));
        reloadContextService.scheduleAtFixedRate(() -> {
            if (this.loggingAdapter.isNeedReloadConfiguration()) {
                this.loggingAdapter.loadConfiguration(this.loggingProperties);
            }
        }, 0L, this.loggingProperties.getReloadInternal(), TimeUnit.SECONDS);
    }

    public static NacosLogging getInstance() {
        return NacosLoggingInstance.INSTANCE;
    }

    public void loadConfiguration() {
        try {
            if (null != this.loggingAdapter) {
                this.loggingAdapter.loadConfiguration(this.loggingProperties);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Load {} Configuration of Nacos fail, message: {}", (Object)LOGGER.getClass().getName(), (Object)t.getMessage());
        }
    }

    private static class NacosLoggingInstance {
        private static final NacosLogging INSTANCE = new NacosLogging();

        private NacosLoggingInstance() {
        }
    }
}

