/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosLoadException;
import com.alibaba.nacos.client.address.AbstractServerListManager;
import com.alibaba.nacos.client.address.PropertiesListProvider;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class NamingServerListManager
extends AbstractServerListManager {
    private static final Logger LOGGER = LogUtils.logger(NamingServerListManager.class);
    private final AtomicInteger currentIndex = new AtomicInteger();
    private String nacosDomain;
    private boolean isDomain;

    @JustForTest
    public NamingServerListManager(Properties properties) {
        this(NacosClientProperties.PROTOTYPE.derive(properties), "");
    }

    public NamingServerListManager(NacosClientProperties properties, String namespace) {
        super(properties, namespace);
    }

    @Override
    public void start() throws NacosException {
        super.start();
        List<String> serverList = this.getServerList();
        if (serverList.isEmpty()) {
            throw new NacosLoadException("serverList is empty,please check configuration");
        }
        this.currentIndex.set(new Random().nextInt(serverList.size()));
        if (this.serverListProvider instanceof PropertiesListProvider && serverList.size() == 1) {
            this.isDomain = true;
            this.nacosDomain = serverList.get(0);
        }
    }

    public String getNacosDomain() {
        return this.nacosDomain;
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    @Override
    protected String getModuleName() {
        return "Naming";
    }

    @Override
    protected NacosRestTemplate getNacosRestTemplate() {
        return NamingHttpClientManager.getInstance().getNacosRestTemplate();
    }

    public String genNextServer() {
        int index = this.currentIndex.incrementAndGet() % this.getServerList().size();
        return this.getServerList().get(index);
    }

    public String getCurrentServer() {
        return this.getServerList().get(this.currentIndex.get() % this.getServerList().size());
    }
}

