/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.configuration;

import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.PropertiesUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ConfigChangeConfigs
extends Subscriber<ServerConfigChangeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChangeConfigs.class);
    private static final String PREFIX = "nacos.core.config.plugin.";
    private Map<String, Properties> configPluginProperties = new HashMap<String, Properties>();

    public ConfigChangeConfigs() {
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.refreshPluginProperties();
    }

    private void refreshPluginProperties() {
        try {
            HashMap<String, Properties> newProperties = new HashMap<String, Properties>(3);
            Properties properties = PropertiesUtil.getPropertiesWithPrefix((Environment)EnvUtil.getEnvironment(), (String)PREFIX);
            if (properties != null) {
                for (String each : properties.stringPropertyNames()) {
                    int typeIndex = each.indexOf(46);
                    String type = each.substring(0, typeIndex);
                    String subKey = each.substring(typeIndex + 1);
                    newProperties.computeIfAbsent(type, key -> new Properties()).setProperty(subKey, properties.getProperty(each));
                }
            }
            this.configPluginProperties = newProperties;
        }
        catch (Exception e) {
            LOGGER.warn("[ConfigChangeConfigs]Refresh config plugin properties failed ", (Throwable)e);
        }
    }

    public Properties getPluginProperties(String configPluginType) {
        if (!this.configPluginProperties.containsKey(configPluginType)) {
            LOGGER.warn("[ConfigChangeConfigs]Can't find config plugin properties for type {}, will use empty properties", (Object)configPluginType);
            return new Properties();
        }
        return this.configPluginProperties.get(configPluginType);
    }

    public void onEvent(ServerConfigChangeEvent event) {
        this.refreshPluginProperties();
    }

    public Class<? extends Event> subscribeType() {
        return ServerConfigChangeEvent.class;
    }
}

