/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.monitor;

import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.core.monitor.NacosMeterRegistryCenter;
import io.micrometer.core.instrument.ImmutableTag;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ConfigDynamicMeterRefreshService {
    private static final String TOPN_CONFIG_CHANGE_REGISTRY = "TOPN_CONFIG_CHANGE_REGISTRY";
    private static final int CONFIG_CHANGE_N = 10;

    @Scheduled(cron="0/30 * * * * *")
    public void refreshTopnConfigChangeCount() {
        NacosMeterRegistryCenter.clear((String)TOPN_CONFIG_CHANGE_REGISTRY);
        List topnConfigChangeCount = MetricsMonitor.getConfigChangeCount().getTopNCounter(10);
        for (Pair configChangeCount : topnConfigChangeCount) {
            ArrayList<ImmutableTag> tags = new ArrayList<ImmutableTag>();
            tags.add(new ImmutableTag("config", (String)configChangeCount.getFirst()));
            NacosMeterRegistryCenter.gauge((String)TOPN_CONFIG_CHANGE_REGISTRY, (String)"config_change_count", tags, (Number)((AtomicInteger)configChangeCount.getSecond()));
        }
    }

    @Scheduled(cron="0 0 0 ? * 1")
    public void resetTopnConfigChangeCount() {
        MetricsMonitor.getConfigChangeCount().reset();
    }
}

