/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigQueryResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.config.server.model.ConfigCacheGray;
import com.alibaba.nacos.config.server.service.query.ConfigChainRequestExtractorService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigQueryRequestHandler
extends RequestHandler<ConfigQueryRequest, ConfigQueryResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigQueryRequestHandler.class);
    private final ConfigQueryChainService configQueryChainService;

    public ConfigQueryRequestHandler(ConfigQueryChainService configQueryChainService) {
        this.configQueryChainService = configQueryChainService;
    }

    @TpsControl(pointName="ConfigQuery")
    @Secured(action=ActionTypes.READ, signType="config")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    public ConfigQueryResponse handle(ConfigQueryRequest request, RequestMeta meta) throws NacosException {
        try {
            String dataId = request.getDataId();
            String group = request.getGroup();
            String tenant = request.getTenant();
            String groupKey = GroupKey2.getKey(dataId, group, tenant);
            boolean notify = request.isNotify();
            String requestIpApp = (String)meta.getLabels().get("Client-AppName");
            String clientIp = meta.getClientIp();
            ConfigQueryChainRequest chainRequest = ConfigChainRequestExtractorService.getExtractor().extract(request, meta);
            ConfigQueryChainResponse chainResponse = this.configQueryChainService.handle(chainRequest);
            if (ResponseCode.FAIL.getCode() == chainResponse.getResultCode()) {
                return ConfigQueryResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)chainResponse.getMessage());
            }
            if (chainResponse.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND) {
                return this.handlerConfigNotFound(request.getDataId(), request.getGroup(), request.getTenant(), requestIpApp, clientIp, notify);
            }
            if (chainResponse.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_QUERY_CONFLICT) {
                return this.handlerConfigConflict(clientIp, groupKey);
            }
            ConfigQueryResponse response = new ConfigQueryResponse();
            if (chainResponse.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_FOUND_GRAY) {
                if ("beta".equals(chainResponse.getMatchedGray().getGrayRule().getType())) {
                    response.setBeta(true);
                } else if ("tag".equals(chainResponse.getMatchedGray().getGrayRule().getType())) {
                    response.setTag(URLEncoder.encode(chainResponse.getMatchedGray().getRawGrayRule(), "UTF-8"));
                }
            }
            if (chainResponse.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.SPECIAL_TAG_CONFIG_NOT_FOUND) {
                response.setTag(request.getTag());
            }
            response.setMd5(chainResponse.getMd5());
            response.setEncryptedDataKey(chainResponse.getEncryptedDataKey());
            response.setContent(chainResponse.getContent());
            response.setContentType(chainResponse.getConfigType());
            response.setLastModified(chainResponse.getLastModified());
            String pullType = "ok";
            if (chainResponse.getContent() == null) {
                pullType = "not-found";
                response.setErrorInfo(300, "config data not exist");
            } else {
                response.setResultCode(ResponseCode.SUCCESS.getCode());
            }
            String pullEvent = this.resolvePullEventType(chainResponse, request.getTag());
            LogUtil.PULL_CHECK_LOG.warn("{}|{}|{}|{}", new Object[]{groupKey, clientIp, response.getMd5(), TimeUtils.getCurrentTimeStr()});
            long delayed = System.currentTimeMillis() - response.getLastModified();
            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, response.getLastModified(), pullEvent, pullType, delayed, clientIp, notify, "grpc");
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle grpc configuration query", (Throwable)e);
            return ConfigQueryResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)e.getMessage());
        }
    }

    private ConfigQueryResponse handlerConfigConflict(String clientIp, String groupKey) {
        ConfigQueryResponse response = new ConfigQueryResponse();
        LogUtil.PULL_LOG.info("[client-get] clientIp={}, {}, get data during dump", (Object)clientIp, (Object)groupKey);
        response.setErrorInfo(400, "requested file is being modified, please try later.");
        return response;
    }

    private ConfigQueryResponse handlerConfigNotFound(String dataId, String group, String tenant, String requestIpApp, String clientIp, boolean notify) {
        ConfigQueryResponse response = new ConfigQueryResponse();
        ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "pull", "not-found", -1L, clientIp, notify, "grpc");
        response.setErrorInfo(300, "config data not exist");
        return response;
    }

    private String resolvePullEventType(ConfigQueryChainResponse chainResponse, String tag) {
        switch (chainResponse.getStatus()) {
            case CONFIG_FOUND_GRAY: {
                ConfigCacheGray matchedGray = chainResponse.getMatchedGray();
                if (matchedGray != null) {
                    return "pull-" + matchedGray.getGrayName();
                }
                return "pull";
            }
            case SPECIAL_TAG_CONFIG_NOT_FOUND: {
                return "pull-tag-" + tag;
            }
        }
        return "pull";
    }
}

