/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigChangeNotifyRequest;
import com.alibaba.nacos.api.remote.AbstractPushCallBack;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.api.remote.request.ServerRequest;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.configuration.ConfigCommonConfig;
import com.alibaba.nacos.config.server.model.event.LocalDataChangeEvent;
import com.alibaba.nacos.config.server.remote.ConfigChangeListenContext;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.ConnectionMeta;
import com.alibaba.nacos.core.remote.RpcPushService;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpcConfigChangeNotifier")
public class RpcConfigChangeNotifier
extends Subscriber<LocalDataChangeEvent> {
    private static final String POINT_CONFIG_PUSH = "CONFIG_PUSH_COUNT";
    private static final String POINT_CONFIG_PUSH_SUCCESS = "CONFIG_PUSH_SUCCESS";
    private static final String POINT_CONFIG_PUSH_FAIL = "CONFIG_PUSH_FAIL";
    TpsControlManager tpsControlManager = ControlManagerCenter.getInstance().getTpsControlManager();
    @Autowired
    ConfigChangeListenContext configChangeListenContext;
    @Autowired
    private RpcPushService rpcPushService;
    @Autowired
    private ConnectionManager connectionManager;

    public RpcConfigChangeNotifier() {
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    @PostConstruct
    void registerTpsPoint() {
        this.tpsControlManager.registerTpsPoint(POINT_CONFIG_PUSH);
        this.tpsControlManager.registerTpsPoint(POINT_CONFIG_PUSH_SUCCESS);
        this.tpsControlManager.registerTpsPoint(POINT_CONFIG_PUSH_FAIL);
    }

    public void configDataChanged(String groupKey, String dataId, String group, String tenant) {
        Set<String> listeners = this.configChangeListenContext.getListeners(groupKey);
        if (CollectionUtils.isEmpty(listeners)) {
            return;
        }
        int notifyClientCount = 0;
        for (String client : listeners) {
            Connection connection = this.connectionManager.getConnection(client);
            if (connection == null) continue;
            ConnectionMeta metaInfo = connection.getMetaInfo();
            String clientIp = metaInfo.getClientIp();
            ConfigChangeNotifyRequest notifyRequest = ConfigChangeNotifyRequest.build((String)dataId, (String)group, (String)tenant);
            RpcPushTask rpcPushRetryTask = new RpcPushTask(notifyRequest, ConfigCommonConfig.getInstance().getMaxPushRetryTimes(), client, clientIp, metaInfo.getAppName());
            RpcConfigChangeNotifier.push(rpcPushRetryTask, this.connectionManager);
            ++notifyClientCount;
        }
        Loggers.REMOTE_PUSH.info("push [{}] clients, groupKey=[{}]", (Object)notifyClientCount, (Object)groupKey);
    }

    public void onEvent(LocalDataChangeEvent event) {
        String groupKey = event.groupKey;
        String[] strings = GroupKey.parseKey(groupKey);
        String dataId = strings[0];
        String group = strings[1];
        String tenant = strings.length > 2 ? strings[2] : "";
        this.configDataChanged(groupKey, dataId, group, tenant);
    }

    public Class<? extends Event> subscribeType() {
        return LocalDataChangeEvent.class;
    }

    private static void push(RpcPushTask retryTask, ConnectionManager connectionManager) {
        ConfigChangeNotifyRequest notifyRequest = retryTask.getNotifyRequest();
        if (retryTask.isOverTimes()) {
            Loggers.REMOTE_PUSH.warn("push callback retry fail over times. dataId={},group={},tenant={},clientId={}, will unregister client.", new Object[]{notifyRequest.getDataId(), notifyRequest.getGroup(), notifyRequest.getTenant(), retryTask.getConnectionId()});
            connectionManager.unregister(retryTask.getConnectionId());
        } else if (connectionManager.getConnection(retryTask.getConnectionId()) != null) {
            ConfigExecutor.scheduleClientConfigNotifier(retryTask, retryTask.getTryTimes() * 2, TimeUnit.SECONDS);
        }
    }

    class RpcPushTask
    implements Runnable {
        ConfigChangeNotifyRequest notifyRequest;
        int maxRetryTimes = -1;
        int tryTimes = 0;
        String connectionId;
        String clientIp;
        String appName;

        public RpcPushTask(ConfigChangeNotifyRequest notifyRequest, int maxRetryTimes, String connectionId, String clientIp, String appName) {
            this.notifyRequest = notifyRequest;
            this.maxRetryTimes = maxRetryTimes;
            this.connectionId = connectionId;
            this.clientIp = clientIp;
            this.appName = appName;
        }

        public boolean isOverTimes() {
            return this.maxRetryTimes > 0 && this.tryTimes >= this.maxRetryTimes;
        }

        public int getTryTimes() {
            return this.tryTimes;
        }

        public ConfigChangeNotifyRequest getNotifyRequest() {
            return this.notifyRequest;
        }

        public int getMaxRetryTimes() {
            return this.maxRetryTimes;
        }

        public String getClientIp() {
            return this.clientIp;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public void run() {
            ++this.tryTimes;
            TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
            tpsCheckRequest.setPointName(RpcConfigChangeNotifier.POINT_CONFIG_PUSH);
            if (!RpcConfigChangeNotifier.this.tpsControlManager.check(tpsCheckRequest).isSuccess()) {
                RpcConfigChangeNotifier.push(this, RpcConfigChangeNotifier.this.connectionManager);
            } else {
                RpcConfigChangeNotifier.this.rpcPushService.pushWithCallback(this.connectionId, (ServerRequest)this.notifyRequest, (PushCallBack)new RpcPushCallback(this, RpcConfigChangeNotifier.this.tpsControlManager, RpcConfigChangeNotifier.this.connectionManager), (Executor)ConfigExecutor.getClientConfigNotifierServiceExecutor());
            }
        }
    }

    static class RpcPushCallback
    extends AbstractPushCallBack {
        RpcPushTask rpcPushTask;
        TpsControlManager tpsControlManager;
        ConnectionManager connectionManager;

        public RpcPushCallback(RpcPushTask rpcPushTask, TpsControlManager tpsControlManager, ConnectionManager connectionManager) {
            super(3000L);
            this.rpcPushTask = rpcPushTask;
            this.tpsControlManager = tpsControlManager;
            this.connectionManager = connectionManager;
        }

        public void onSuccess() {
            TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
            tpsCheckRequest.setPointName(RpcConfigChangeNotifier.POINT_CONFIG_PUSH_SUCCESS);
            this.tpsControlManager.check(tpsCheckRequest);
        }

        public void onFail(Throwable e) {
            TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
            tpsCheckRequest.setPointName(RpcConfigChangeNotifier.POINT_CONFIG_PUSH_FAIL);
            this.tpsControlManager.check(tpsCheckRequest);
            Loggers.REMOTE_PUSH.warn("Push fail, dataId={}, group={}, tenant={}, clientId={}", new Object[]{this.rpcPushTask.getNotifyRequest().getDataId(), this.rpcPushTask.getNotifyRequest().getGroup(), this.rpcPushTask.getNotifyRequest().getTenant(), this.rpcPushTask.getConnectionId(), e});
            RpcConfigChangeNotifier.push(this.rpcPushTask, this.connectionManager);
        }
    }
}

