/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.MapUtil;
import com.alibaba.nacos.common.utils.NumberUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.gray.ConfigGrayPersistInfo;
import com.alibaba.nacos.config.server.model.gray.GrayRule;
import com.alibaba.nacos.config.server.model.gray.GrayRuleManager;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ConfigOperationService {
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoTagPersistService configInfoTagPersistService;
    private ConfigInfoBetaPersistService configInfoBetaPersistService;
    private ConfigInfoGrayPersistService configInfoGrayPersistService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigOperationService.class);
    private static final int DEFAULT_MAX_GRAY_VERSION_COUNT = 10;

    public ConfigOperationService(ConfigInfoPersistService configInfoPersistService, ConfigInfoTagPersistService configInfoTagPersistService, ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
    }

    public Boolean publishConfig(ConfigForm configForm, ConfigRequestInfo configRequestInfo, String encryptedDataKey) throws NacosException {
        ConfigOperateResult configOperateResult;
        Map<String, Object> configAdvanceInfo = this.getConfigAdvanceInfo(configForm);
        ParamUtils.checkParam(configAdvanceInfo);
        configForm.setEncryptedDataKey(encryptedDataKey);
        ConfigInfo configInfo = new ConfigInfo(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getAppName(), configForm.getContent());
        if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
            configInfo.setMd5(configRequestInfo.getCasMd5());
        }
        configInfo.setType(configForm.getType());
        configInfo.setEncryptedDataKey(encryptedDataKey);
        if (StringUtils.isNotBlank((String)configRequestInfo.getBetaIps())) {
            configForm.setGrayName("beta");
            configForm.setGrayRuleExp(configRequestInfo.getBetaIps());
            configForm.setGrayVersion("1.0.0");
            this.persistBeta(configForm, configInfo, configRequestInfo);
            configForm.setGrayPriority(Integer.MAX_VALUE);
            this.publishConfigGray("beta", configForm, configRequestInfo);
            return Boolean.TRUE;
        }
        if (StringUtils.isNotBlank((String)configForm.getTag())) {
            configForm.setGrayName("tag_" + configForm.getTag());
            configForm.setGrayRuleExp(configForm.getTag());
            configForm.setGrayVersion("1.0.0");
            configForm.setGrayPriority(0x7FFFFFFE);
            this.persistTagv1(configForm, configInfo, configRequestInfo);
            this.publishConfigGray("tag", configForm, configRequestInfo);
            return Boolean.TRUE;
        }
        if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
            configOperateResult = this.configInfoPersistService.insertOrUpdateCas(configRequestInfo.getSrcIp(), configForm.getSrcUser(), configInfo, configAdvanceInfo);
            if (!configOperateResult.isSuccess()) {
                LOGGER.warn("[cas-publish-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5()});
                throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish fail, server md5 may have changed.");
            }
        } else {
            configOperateResult = this.configInfoPersistService.insertOrUpdate(configRequestInfo.getSrcIp(), configForm.getSrcUser(), configInfo, configAdvanceInfo);
        }
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configOperateResult.getLastModified()));
        ConfigTraceService.logPersistenceEvent(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configRequestInfo.getRequestIpApp(), configOperateResult.getLastModified(), InetUtils.getSelfIP(), "persist", "pub", configForm.getContent());
        return true;
    }

    private void persistTagv1(ConfigForm configForm, ConfigInfo configInfo, ConfigRequestInfo configRequestInfo) throws NacosApiException {
        if (!PropertyUtil.isGrayCompatibleModel()) {
            return;
        }
        ConfigOperateResult configOperateResult = null;
        if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
            configOperateResult = this.configInfoTagPersistService.insertOrUpdateTagCas(configInfo, configForm.getTag(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
            if (!configOperateResult.isSuccess()) {
                LOGGER.warn("[cas-publish-tag-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5()});
                throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish tag config fail, server md5 may have changed.");
            }
        } else {
            configOperateResult = this.configInfoTagPersistService.insertOrUpdateTag(configInfo, configForm.getTag(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
        }
    }

    private void persistBeta(ConfigForm configForm, ConfigInfo configInfo, ConfigRequestInfo configRequestInfo) throws NacosApiException {
        if (!PropertyUtil.isGrayCompatibleModel()) {
            return;
        }
        ConfigOperateResult configOperateResult = null;
        if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
            configOperateResult = this.configInfoBetaPersistService.insertOrUpdateBetaCas(configInfo, configRequestInfo.getBetaIps(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
            if (!configOperateResult.isSuccess()) {
                LOGGER.warn("[cas-publish-beta-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5()});
                throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish beta config fail, server md5 may have changed.");
            }
        } else {
            this.configInfoBetaPersistService.insertOrUpdateBeta(configInfo, configRequestInfo.getBetaIps(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
        }
    }

    private Boolean publishConfigGray(String grayType, ConfigForm configForm, ConfigRequestInfo configRequestInfo) throws NacosException {
        ConfigOperateResult configOperateResult;
        Map<String, Object> configAdvanceInfo = this.getConfigAdvanceInfo(configForm);
        ParamUtils.checkParam(configAdvanceInfo);
        ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo(grayType, configForm.getGrayVersion(), configForm.getGrayRuleExp(), configForm.getGrayPriority());
        GrayRule grayRuleStruct = GrayRuleManager.constructGrayRule(localConfigGrayPersistInfo);
        if (grayRuleStruct == null) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.CONFIG_GRAY_VERSION_INVALID, ErrorCode.CONFIG_GRAY_VERSION_INVALID.getMsg());
        }
        if (!grayRuleStruct.isValid()) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.CONFIG_GRAY_RULE_FORMAT_INVALID, ErrorCode.CONFIG_GRAY_RULE_FORMAT_INVALID.getMsg());
        }
        if (this.checkGrayVersionOverMaxCount(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getGrayName())) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.CONFIG_GRAY_OVER_MAX_VERSION_COUNT, "gray config version is over max count :" + this.getMaxGrayVersionCount());
        }
        ConfigInfo configInfo = new ConfigInfo(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getAppName(), configForm.getContent());
        configInfo.setType(configForm.getType());
        configInfo.setEncryptedDataKey(configForm.getEncryptedDataKey());
        if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
            configOperateResult = this.configInfoGrayPersistService.insertOrUpdateGrayCas(configInfo, configForm.getGrayName(), GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), configRequestInfo.getSrcIp(), configForm.getSrcUser());
            if (!configOperateResult.isSuccess()) {
                LOGGER.warn("[cas-publish-gray-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, grayName = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5(), configForm.getGrayName()});
                throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish gray config fail, server md5 may have changed.");
            }
        } else {
            configOperateResult = this.configInfoGrayPersistService.insertOrUpdateGray(configInfo, configForm.getGrayName(), GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), configRequestInfo.getSrcIp(), configForm.getSrcUser());
        }
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getGrayName(), configOperateResult.getLastModified()));
        String eventType = "persist-" + configForm.getGrayName();
        ConfigTraceService.logPersistenceEvent(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configRequestInfo.getRequestIpApp(), configOperateResult.getLastModified(), InetUtils.getSelfIP(), eventType, "pub", configForm.getContent());
        return true;
    }

    private boolean checkGrayVersionOverMaxCount(String dataId, String group, String tenant, String grayName) {
        List<String> configInfoGrays = this.configInfoGrayPersistService.findConfigInfoGrays(dataId, group, tenant);
        if (configInfoGrays == null || configInfoGrays.isEmpty()) {
            return false;
        }
        if (configInfoGrays.contains(grayName)) {
            return false;
        }
        return configInfoGrays.size() >= this.getMaxGrayVersionCount();
    }

    private int getMaxGrayVersionCount() {
        String value = EnvUtil.getProperty((String)"nacos.config.gray.version.max.count", (String)"");
        return NumberUtils.isDigits((String)value) ? NumberUtils.toInt((String)value) : 10;
    }

    public Boolean deleteConfig(String dataId, String group, String namespaceId, String tag, String clientIp, String srcUser) {
        String persistEvent = "persist";
        String grayName = "";
        if (StringUtils.isBlank((CharSequence)tag)) {
            this.configInfoPersistService.removeConfigInfo(dataId, group, namespaceId, clientIp, srcUser);
        } else {
            persistEvent = "persist-tag-" + tag;
            grayName = "tag_" + tag;
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, namespaceId, grayName, clientIp, srcUser);
            this.deleteConfigTagv1(dataId, group, namespaceId, tag, clientIp, srcUser);
        }
        Timestamp time = TimeUtils.getCurrentTime();
        ConfigTraceService.logPersistenceEvent(dataId, group, namespaceId, null, time.getTime(), clientIp, persistEvent, "remove", null);
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(dataId, group, namespaceId, grayName, time.getTime()));
        return true;
    }

    private void deleteConfigTagv1(String dataId, String group, String namespaceId, String tag, String clientIp, String srcUser) {
        if (PropertyUtil.isGrayCompatibleModel()) {
            this.configInfoTagPersistService.removeConfigInfoTag(dataId, group, namespaceId, tag, clientIp, srcUser);
        }
    }

    public Map<String, Object> getConfigAdvanceInfo(ConfigForm configForm) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"config_tags", (Object)configForm.getConfigTags());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"desc", (Object)configForm.getDesc());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"use", (Object)configForm.getUse());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"effect", (Object)configForm.getEffect());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"type", (Object)configForm.getType());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"schema", (Object)configForm.getSchema());
        return configAdvanceInfo;
    }
}

