/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.dump.DumpChangeConfigWorker;
import com.alibaba.nacos.config.server.service.dump.DumpChangeGrayConfigWorker;
import com.alibaba.nacos.config.server.service.dump.DumpRequest;
import com.alibaba.nacos.config.server.service.dump.HistoryConfigCleaner;
import com.alibaba.nacos.config.server.service.dump.HistoryConfigCleanerConfig;
import com.alibaba.nacos.config.server.service.dump.HistoryConfigCleanerManager;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskServiceFactory;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllGrayProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpProcessor;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllGrayTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpTask;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.TimerContext;
import java.sql.Timestamp;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DumpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DumpService.class);
    protected DumpProcessor processor;
    protected DumpAllProcessor dumpAllProcessor;
    protected DumpAllGrayProcessor dumpAllGrayProcessor;
    protected ConfigInfoPersistService configInfoPersistService;
    protected NamespacePersistService namespacePersistService;
    protected HistoryConfigInfoPersistService historyConfigInfoPersistService;
    protected ConfigInfoGrayPersistService configInfoGrayPersistService;
    protected final ServerMemberManager memberManager;
    static final int DUMP_ALL_INTERVAL_IN_MINUTE = 360;
    static final int INITIAL_DELAY_IN_MINUTE = 360;
    private TaskManager dumpTaskMgr;
    private TaskManager dumpAllTaskMgr;
    static final int INIT_THREAD_COUNT = 10;
    int total = 0;

    public DumpService(ConfigInfoPersistService configInfoPersistService, NamespacePersistService namespacePersistService, HistoryConfigInfoPersistService historyConfigInfoPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService, ServerMemberManager memberManager) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
        this.namespacePersistService = namespacePersistService;
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        this.memberManager = memberManager;
        this.processor = new DumpProcessor(this.configInfoPersistService, this.configInfoGrayPersistService);
        this.dumpAllProcessor = new DumpAllProcessor(this.configInfoPersistService);
        this.dumpAllGrayProcessor = new DumpAllGrayProcessor(this.configInfoGrayPersistService);
        this.dumpTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpTaskManager");
        this.dumpTaskMgr.setDefaultTaskProcessor(this.processor);
        this.dumpAllTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpAllTaskManager");
        this.dumpAllTaskMgr.setDefaultTaskProcessor(this.dumpAllProcessor);
        this.dumpAllTaskMgr.addProcessor("dumpAllConfigTask", this.dumpAllProcessor);
        DynamicDataSource.getInstance().getDataSource();
        NotifyCenter.registerSubscriber((Subscriber)new Subscriber(){

            public void onEvent(Event event) {
                DumpService.this.handleConfigDataChange(event);
            }

            public Class<? extends Event> subscribeType() {
                return ConfigDataChangeEvent.class;
            }
        });
    }

    void handleConfigDataChange(Event event) {
        if (event instanceof ConfigDataChangeEvent) {
            ConfigDataChangeEvent evt = (ConfigDataChangeEvent)event;
            DumpRequest dumpRequest = DumpRequest.create(evt.dataId, evt.group, evt.tenant, evt.lastModifiedTs, NetUtils.localIP());
            dumpRequest.setGrayName(evt.grayName);
            this.dump(dumpRequest);
        }
    }

    protected abstract void init() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpOperate() throws NacosException {
        String dumpFileContext = "CONFIG_DUMP_TO_FILE";
        TimerContext.start((String)dumpFileContext);
        try {
            LogUtil.DEFAULT_LOG.warn("DumpService start");
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            try {
                this.dumpAllConfigInfoOnStartup(this.dumpAllProcessor);
                LogUtil.DEFAULT_LOG.info("start clear all config-info-gray.");
                ConfigDiskServiceFactory.getInstance().clearAllGray();
                this.dumpAllGrayProcessor.process((NacosTask)new DumpAllGrayTask());
            }
            catch (Exception e) {
                LogUtil.FATAL_LOG.error("Nacos Server did not start because dumpservice bean construction failure :\n" + e);
                throw new NacosException(500, "Nacos Server did not start because dumpservice bean construction failure :\n" + e.getMessage(), (Throwable)e);
            }
            if (!EnvUtil.getStandaloneMode()) {
                Random random = new Random();
                long initialDelay = random.nextInt(360) + 10;
                LogUtil.DEFAULT_LOG.warn("initialDelay:{}", (Object)initialDelay);
                ConfigExecutor.scheduleConfigTask(new DumpAllProcessorRunner(), initialDelay, 360L, TimeUnit.MINUTES);
                ConfigExecutor.scheduleConfigTask(new DumpAllGrayProcessorRunner(), initialDelay, 360L, TimeUnit.MINUTES);
                ConfigExecutor.scheduleConfigChangeTask(new DumpChangeConfigWorker(this.configInfoPersistService, this.historyConfigInfoPersistService, currentTime), random.nextInt((int)PropertyUtil.getDumpChangeWorkerInterval()), TimeUnit.MILLISECONDS);
                ConfigExecutor.scheduleConfigChangeTask(new DumpChangeGrayConfigWorker(this.configInfoGrayPersistService, currentTime, this.historyConfigInfoPersistService), random.nextInt((int)PropertyUtil.getDumpChangeWorkerInterval()), TimeUnit.MILLISECONDS);
            }
            HistoryConfigCleaner cleaner = HistoryConfigCleanerManager.getHistoryConfigCleaner(HistoryConfigCleanerConfig.getInstance().getActiveHistoryConfigCleaner());
            ConfigExecutor.scheduleConfigTask(new ConfigHistoryClear(cleaner), 10L, 10L, TimeUnit.MINUTES);
        }
        finally {
            TimerContext.end((String)dumpFileContext, (Logger)LogUtil.DUMP_LOG);
        }
    }

    private void dumpAllConfigInfoOnStartup(DumpAllProcessor dumpAllProcessor) {
        try {
            LogUtil.DEFAULT_LOG.info("start clear all config-info.");
            ConfigDiskServiceFactory.getInstance().clearAll();
            dumpAllProcessor.process((NacosTask)new DumpAllTask(true));
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("dump config fail" + e.getMessage());
            throw e;
        }
    }

    public void dump(DumpRequest dumpRequest) {
        if (StringUtils.isNotBlank((String)dumpRequest.getGrayName())) {
            this.dumpGray(dumpRequest.getDataId(), dumpRequest.getGroup(), dumpRequest.getTenant(), dumpRequest.getGrayName(), dumpRequest.getLastModifiedTs(), dumpRequest.getSourceIp());
        } else {
            this.dumpFormal(dumpRequest.getDataId(), dumpRequest.getGroup(), dumpRequest.getTenant(), dumpRequest.getLastModifiedTs(), dumpRequest.getSourceIp());
        }
    }

    private void dumpFormal(String dataId, String group, String tenant, long lastModified, String handleIp) {
        String groupKey;
        String taskKey = groupKey = GroupKey2.getKey(dataId, group, tenant);
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, null, lastModified, handleIp));
        LogUtil.DUMP_LOG.info("[dump] add formal task. groupKey={}", (Object)groupKey);
    }

    private void dumpGray(String dataId, String group, String tenant, String grayName, long lastModified, String handleIp) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String taskKey = groupKey + "+gray+" + grayName;
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, grayName, lastModified, handleIp));
        LogUtil.DUMP_LOG.info("[dump] add gray task. groupKey={},grayName={}", (Object)groupKey, (Object)grayName);
    }

    public void dumpAll() {
        this.dumpAllTaskMgr.addTask((Object)"dumpAllConfigTask", new DumpAllTask());
    }

    protected abstract boolean canExecute();

    class DumpAllProcessorRunner
    implements Runnable {
        DumpAllProcessorRunner() {
        }

        @Override
        public void run() {
            DumpService.this.dumpAllTaskMgr.addTask((Object)"dumpAllConfigTask", new DumpAllTask());
        }
    }

    class DumpAllGrayProcessorRunner
    implements Runnable {
        DumpAllGrayProcessorRunner() {
        }

        @Override
        public void run() {
            DumpService.this.dumpAllTaskMgr.addTask((Object)"dumpAllGrayConfigTask", new DumpAllGrayTask());
        }
    }

    class ConfigHistoryClear
    implements Runnable {
        private HistoryConfigCleaner historyConfigCleaner;

        public ConfigHistoryClear(HistoryConfigCleaner historyConfigCleaner) {
            this.historyConfigCleaner = historyConfigCleaner;
        }

        @Override
        public void run() {
            LOGGER.warn("clearHistoryConfig get scheduled");
            if (DumpService.this.canExecute()) {
                try {
                    LOGGER.warn("clearHistoryConfig is enable in current context, try to run cleaner");
                    this.historyConfigCleaner.cleanHistoryConfig();
                    LOGGER.warn("history config cleaner successfully");
                }
                catch (Throwable e) {
                    LOGGER.error("clearConfigHistory error : {}", (Object)e.toString());
                }
            } else {
                LOGGER.warn("clearHistoryConfig is disable in current context");
            }
        }
    }
}

