/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.processor;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.service.ClientIpWhiteList;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.SwitchService;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllTask;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.persistence.model.Page;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DumpAllProcessor
implements NacosTaskProcessor {
    final ConfigInfoPersistService configInfoPersistService;

    public DumpAllProcessor(ConfigInfoPersistService configInfoPersistService) {
        this.configInfoPersistService = configInfoPersistService;
    }

    public boolean process(NacosTask task) {
        if (!(task instanceof DumpAllTask)) {
            LogUtil.DEFAULT_LOG.error("[all-dump-error] ,invalid task type {},DumpAllProcessor should process DumpAllTask type.", (Object)task.getClass().getSimpleName());
            return false;
        }
        DumpAllTask dumpAllTask = (DumpAllTask)task;
        long currentMaxId = this.configInfoPersistService.findConfigMaxId();
        long lastMaxId = 0L;
        ThreadPoolExecutor executorService = null;
        executorService = dumpAllTask.isStartUp() ? new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(PropertyUtil.getAllDumpPageSize() * 2), r -> new Thread(r, "dump all executor"), new ThreadPoolExecutor.CallerRunsPolicy()) : new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, "dump all executor"), new ThreadPoolExecutor.CallerRunsPolicy());
        LogUtil.DEFAULT_LOG.info("start dump all config-info...");
        while (lastMaxId < currentMaxId) {
            long start = System.currentTimeMillis();
            Page<ConfigInfoWrapper> page = this.configInfoPersistService.findAllConfigInfoFragment(lastMaxId, PropertyUtil.getAllDumpPageSize(), dumpAllTask.isStartUp());
            long dbTimeStamp = System.currentTimeMillis();
            if (page == null || page.getPageItems() == null || page.getPageItems().isEmpty()) break;
            for (ConfigInfoWrapper cf : page.getPageItems()) {
                lastMaxId = Math.max(cf.getId(), lastMaxId);
                if (!dumpAllTask.isStartUp()) {
                    boolean md5Update;
                    String groupKey = GroupKey2.getKey(cf.getDataId(), cf.getGroup(), cf.getTenant());
                    boolean newLastModified = cf.getLastModified() > ConfigCacheService.getLastModifiedTs(groupKey);
                    String localContentMd5 = ConfigCacheService.getContentMd5(groupKey);
                    boolean bl = md5Update = !localContentMd5.equals(cf.getMd5());
                    if (!newLastModified && !md5Update) continue;
                    LogUtil.DUMP_LOG.info("[dump-all] find change config {}, {}, md5={}", new Object[]{groupKey, cf.getLastModified(), cf.getMd5()});
                    cf = this.configInfoPersistService.findConfigInfo(cf.getDataId(), cf.getGroup(), cf.getTenant());
                }
                if (cf == null) continue;
                if (cf.getDataId().equals("com.alibaba.nacos.metadata.clientIpWhitelist")) {
                    ClientIpWhiteList.load(cf.getContent());
                }
                if (cf.getDataId().equals("com.alibaba.nacos.meta.switch")) {
                    SwitchService.load(cf.getContent());
                }
                String content = cf.getContent();
                String dataId = cf.getDataId();
                String group = cf.getGroup();
                String tenant = cf.getTenant();
                long lastModified = cf.getLastModified();
                String type = cf.getType();
                String encryptedDataKey = cf.getEncryptedDataKey();
                executorService.execute(() -> {
                    String md5Utf8 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
                    boolean result = ConfigCacheService.dumpWithMd5(dataId, group, tenant, content, md5Utf8, lastModified, type, encryptedDataKey);
                    if (result) {
                        LogUtil.DUMP_LOG.info("[dump-all-ok] {}, {}, length={},md5UTF8={}", new Object[]{GroupKey2.getKey(dataId, group), lastModified, content.length(), md5Utf8});
                    } else {
                        LogUtil.DUMP_LOG.info("[dump-all-error] {}", (Object)GroupKey2.getKey(dataId, group));
                    }
                });
            }
            long diskStamp = System.currentTimeMillis();
            LogUtil.DEFAULT_LOG.info("[all-dump] submit all task for {} / {}, dbTime={},diskTime={}", new Object[]{lastMaxId, currentMaxId, dbTimeStamp - start, diskStamp - dbTimeStamp});
        }
        try {
            int unfinishedTaskCount = 0;
            while ((unfinishedTaskCount = executorService.getQueue().size() + executorService.getActiveCount()) > 0) {
                LogUtil.DEFAULT_LOG.info("[all-dump] wait {} dump tasks to be finished", (Object)unfinishedTaskCount);
                Thread.sleep(1000L);
            }
            executorService.shutdown();
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.error("[all-dump] wait  dump tasks to be finished error", (Throwable)e);
        }
        LogUtil.DEFAULT_LOG.info("success to  dump all config-info\u3002");
        return true;
    }
}

