/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.query;

import com.alibaba.nacos.config.server.service.query.handler.ConfigQueryHandler;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigQueryHandlerChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigQueryHandlerChain.class);
    private ConfigQueryHandler head;
    private ConfigQueryHandler tail;

    public ConfigQueryHandlerChain addHandler(ConfigQueryHandler handler) {
        if (Objects.isNull(handler)) {
            LOGGER.warn("Attempted to add a null config query handler");
            return this;
        }
        if (this.head == null) {
            this.head = handler;
            this.tail = handler;
        } else {
            this.tail.setNextHandler(handler);
            this.tail = handler;
        }
        return this;
    }

    public ConfigQueryChainResponse handle(ConfigQueryChainRequest request) throws IOException {
        return this.head.handle(request);
    }
}

