/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.query;

import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainRequestExtractor;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class DefaultChainRequestExtractor
implements ConfigQueryChainRequestExtractor {
    @Override
    public String getName() {
        return "nacos";
    }

    @Override
    public ConfigQueryChainRequest extract(HttpServletRequest request) {
        String dataId = request.getParameter("dataId");
        String group = request.getParameter("group");
        String tenant = request.getParameter("tenant");
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = "";
        }
        String tag = request.getParameter("tag");
        String autoTag = request.getHeader("Vipserver-Tag");
        String clientIp = RequestUtil.getRemoteIp(request);
        HashMap<String, String> appLabels = new HashMap<String, String>(4);
        appLabels.put("ClientIp", clientIp);
        if (StringUtils.isNotBlank((String)tag)) {
            appLabels.put("Vipserver-Tag", tag);
        } else if (StringUtils.isNotBlank((String)autoTag)) {
            appLabels.put("Vipserver-Tag", autoTag);
        }
        ConfigQueryChainRequest chainRequest = new ConfigQueryChainRequest();
        chainRequest.setDataId(dataId);
        chainRequest.setGroup(group);
        chainRequest.setTenant(tenant);
        chainRequest.setTag(tag);
        chainRequest.setAppLabels(appLabels);
        return chainRequest;
    }

    @Override
    public ConfigQueryChainRequest extract(ConfigQueryRequest request, RequestMeta requestMeta) {
        ConfigQueryChainRequest chainRequest = new ConfigQueryChainRequest();
        String tag = request.getTag();
        HashMap<String, String> appLabels = new HashMap<String, String>(4);
        appLabels.put("ClientIp", requestMeta.getClientIp());
        if (StringUtils.isNotBlank((String)tag)) {
            appLabels.put("Vipserver-Tag", tag);
        } else {
            appLabels.putAll(requestMeta.getAppLabels());
        }
        chainRequest.setDataId(request.getDataId());
        chainRequest.setGroup(request.getGroup());
        chainRequest.setTenant(request.getTenant());
        chainRequest.setTag(request.getTag());
        chainRequest.setAppLabels(appLabels);
        return chainRequest;
    }
}

