/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.query.handler;

import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.query.handler.AbstractConfigQueryHandler;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChainEntryHandler
extends AbstractConfigQueryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChainEntryHandler.class);
    private static final String CHAIN_ENTRY_HANDLER = "chainEntryHandler";
    private static final ThreadLocal<CacheItem> CACHE_ITEM_THREAD_LOCAL = new ThreadLocal();

    @Override
    public String getName() {
        return CHAIN_ENTRY_HANDLER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigQueryChainResponse handle(ConfigQueryChainRequest request) throws IOException {
        String groupKey = GroupKey2.getKey(request.getDataId(), request.getGroup(), request.getTenant());
        int lockResult = ConfigCacheService.tryConfigReadLock(groupKey);
        CacheItem cacheItem = ConfigCacheService.getContentCache(groupKey);
        if (lockResult > 0 && cacheItem != null) {
            try {
                CACHE_ITEM_THREAD_LOCAL.set(cacheItem);
                if (this.nextHandler != null) {
                    ConfigQueryChainResponse configQueryChainResponse = this.nextHandler.handle(request);
                    return configQueryChainResponse;
                }
                LOGGER.warn("chainEntryHandler's next handler is null");
                ConfigQueryChainResponse configQueryChainResponse = new ConfigQueryChainResponse();
                return configQueryChainResponse;
            }
            finally {
                CACHE_ITEM_THREAD_LOCAL.remove();
                ConfigCacheService.releaseReadLock(groupKey);
            }
        }
        if (lockResult == 0 || cacheItem == null) {
            ConfigQueryChainResponse response = new ConfigQueryChainResponse();
            response.setStatus(ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND);
            return response;
        }
        ConfigQueryChainResponse response = new ConfigQueryChainResponse();
        response.setStatus(ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_QUERY_CONFLICT);
        return response;
    }

    public static CacheItem getThreadLocalCacheItem() {
        return CACHE_ITEM_THREAD_LOCAL.get();
    }

    public static void removeThreadLocalCacheItem() {
        CACHE_ITEM_THREAD_LOCAL.remove();
    }
}

