/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.HistoryConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedHistoryConfigInfoPersistServiceImpl")
public class EmbeddedHistoryConfigInfoPersistServiceImpl
implements HistoryConfigInfoPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedHistoryConfigInfoPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public void insertConfigHistoryAtomic(long configHistoryId, ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, String ops, String publishType, String grayName, String extInfo) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String publishTypeTmp = StringUtils.defaultEmptyIfBlank((String)publishType);
        String encryptedDataKey = StringUtils.defaultEmptyIfBlank((String)configInfo.getEncryptedDataKey());
        String grayNameTemp = StringUtils.defaultEmptyIfBlank((String)grayName);
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sql = historyConfigInfoMapper.insert(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_modified", "op_type", "publish_type", "gray_name", "ext_info", "encrypted_data_key"));
        Object[] args = new Object[]{configHistoryId, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, ops, publishTypeTmp, grayNameTemp, extInfo, encryptedDataKey};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
    }

    @Override
    public void removeConfigHistory(Timestamp startTime, int limitSize) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("startTime", (Object)startTime);
        context.putWhereParameter("limitSize", (Object)limitSize);
        MapperResult mapperResult = historyConfigInfoMapper.removeConfigHistory(context);
        PaginationHelper helper = this.createPaginationHelper();
        helper.updateLimit(mapperResult.getSql(), mapperResult.getParamList().toArray());
    }

    @Override
    public List<ConfigInfoStateWrapper> findDeletedConfig(Timestamp startTime, long lastMaxId, int pageSize, String publishType) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("startTime", (Object)startTime);
        context.putWhereParameter("pageSize", (Object)pageSize);
        context.putWhereParameter("lastMaxId", (Object)lastMaxId);
        context.putWhereParameter("publishType", (Object)publishType);
        MapperResult mapperResult = historyConfigInfoMapper.findDeletedConfig(context);
        List configHistoryInfos = this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
        ArrayList<ConfigInfoStateWrapper> configInfoStateWrappers = new ArrayList<ConfigInfoStateWrapper>();
        for (ConfigHistoryInfo configHistoryInfo : configHistoryInfos) {
            ConfigInfoStateWrapper configInfoStateWrapper = new ConfigInfoStateWrapper();
            configInfoStateWrapper.setId(configHistoryInfo.getId());
            configInfoStateWrapper.setDataId(configHistoryInfo.getDataId());
            configInfoStateWrapper.setGroup(configHistoryInfo.getGroup());
            configInfoStateWrapper.setTenant(configHistoryInfo.getTenant());
            configInfoStateWrapper.setMd5(configHistoryInfo.getMd5());
            configInfoStateWrapper.setLastModified(configHistoryInfo.getLastModifiedTime().getTime());
            configInfoStateWrapper.setGrayName(configHistoryInfo.getGrayName());
            configInfoStateWrappers.add(configInfoStateWrapper);
        }
        return configInfoStateWrappers;
    }

    @Override
    public Page<ConfigHistoryInfo> findConfigHistory(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext((pageNo - 1) * pageSize, pageSize);
        context.putWhereParameter("dataId", (Object)dataId);
        context.putWhereParameter("groupId", (Object)group);
        context.putWhereParameter("tenantId", (Object)tenantTmp);
        String sqlCountRows = historyConfigInfoMapper.count(Arrays.asList("data_id", "group_id", "tenant_id"));
        MapperResult sqlFetchRows = historyConfigInfoMapper.pageFindConfigHistoryFetchRows(context);
        PaginationHelper helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows, sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.HISTORY_LIST_ROW_MAPPER);
    }

    @Override
    public ConfigHistoryInfo detailConfigHistory(Long nid) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlFetchRows = historyConfigInfoMapper.select(Arrays.asList("nid", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_user", "src_ip", "op_type", "publish_type", "gray_name", "ext_info", "gmt_create", "gmt_modified", "encrypted_data_key"), Collections.singletonList("nid"));
        return (ConfigHistoryInfo)this.databaseOperate.queryOne(sqlFetchRows, new Object[]{nid}, (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
    }

    @Override
    public ConfigHistoryInfo detailPreviousConfigHistory(Long id) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)id);
        MapperResult sqlFetchRows = historyConfigInfoMapper.detailPreviousConfigHistory(context);
        return (ConfigHistoryInfo)this.databaseOperate.queryOne(sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
    }

    @Override
    public int findConfigHistoryCountByTime(Timestamp startTime) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("startTime", (Object)startTime);
        MapperResult sqlFetchRows = historyConfigInfoMapper.findConfigHistoryCountByTime(context);
        Integer result = (Integer)this.databaseOperate.queryOne(sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("findConfigHistoryCountByTime error");
        }
        return result;
    }

    @Override
    public ConfigHistoryInfo getNextHistoryInfo(String dataId, String group, String tenant, String publishType, String grayName, long startNid) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("dataId", (Object)dataId);
        context.putWhereParameter("groupId", (Object)group);
        context.putWhereParameter("tenantId", (Object)tenant);
        context.putWhereParameter("publishType", (Object)publishType);
        context.putWhereParameter("grayName", (Object)grayName);
        context.putWhereParameter("nid", (Object)startNid);
        MapperResult sqlFetchRows = historyConfigInfoMapper.getNextHistoryInfo(context);
        return (ConfigHistoryInfo)this.databaseOperate.queryOne(sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.HISTORY_DETAIL_ROW_MAPPER);
    }
}

