/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.ConfigExtInfoUtil;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnExternalStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoGrayMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoGrayPersistServiceImpl")
public class ExternalConfigInfoGrayPersistServiceImpl
implements ConfigInfoGrayPersistService {
    private DataSourceService dataSourceService;
    protected JdbcTemplate jt;
    protected TransactionTemplate tjt;
    private MapperManager mapperManager;
    private HistoryConfigInfoPersistService historyConfigInfoPersistService;

    public ExternalConfigInfoGrayPersistServiceImpl(@Qualifier(value="externalHistoryConfigInfoPersistServiceImpl") HistoryConfigInfoPersistService historyConfigInfoPersistService) {
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jt = this.dataSourceService.getJdbcTemplate();
        this.tjt = this.dataSourceService.getTransactionTemplate();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfo4GrayState(String dataId, String group, String tenant, String grayName) {
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        try {
            return (ConfigInfoStateWrapper)this.jt.queryForObject(configInfoGrayMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gray_rule", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name")), new Object[]{dataId, group, tenantTmp, grayNameTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private ConfigOperateResult getGrayOperateResult(String dataId, String group, String tenant, String grayName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoStateWrapper configInfo4Gray = this.findConfigInfo4GrayState(dataId, group, tenantTmp, grayName);
        if (configInfo4Gray == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfo4Gray.getId(), configInfo4Gray.getLastModified());
    }

    @Override
    public ConfigOperateResult addConfigInfo4Gray(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        return (ConfigOperateResult)this.tjt.execute(status -> {
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant().trim();
            String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
            String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
            try {
                this.addConfigInfoGrayAtomic(-1L, configInfo, grayNameTmp, grayRuleTmp, srcIp, srcUser);
                if (!PropertyUtil.GRAY_MIGRATE_FLAG.get().booleanValue()) {
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    this.historyConfigInfoPersistService.insertConfigHistoryAtomic(0L, configInfo, srcIp, srcUser, now, "I", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(grayNameTmp, grayRuleTmp, srcUser));
                }
                return this.getGrayOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
            }
            catch (Exception e) {
                LogUtil.FATAL_LOG.error("[db-error] " + e, (Throwable)e);
                throw e;
            }
        });
    }

    @Override
    public void addConfigInfoGrayAtomic(long configGrayId, ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        this.jt.update(configInfoGrayMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "gray_name", "gray_rule", "app_name", "content", "encrypted_data_key", "md5", "src_ip", "src_user", "gmt_create@NOW()", "gmt_modified@NOW()")), new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayName, grayRule, appNameTmp, configInfo.getContent(), encryptedDataKey, md5, srcIp, srcUser});
    }

    @Override
    public ConfigOperateResult insertOrUpdateGray(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        if (this.findConfigInfo4GrayState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), grayName) == null) {
            return this.addConfigInfo4Gray(configInfo, grayName, grayRule, srcIp, srcUser);
        }
        return this.updateConfigInfo4Gray(configInfo, grayName, grayRule, srcIp, srcUser);
    }

    @Override
    public ConfigOperateResult insertOrUpdateGrayCas(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        if (this.findConfigInfo4GrayState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), grayName) == null) {
            return this.addConfigInfo4Gray(configInfo, grayName, grayRule, srcIp, srcUser);
        }
        return this.updateConfigInfo4GrayCas(configInfo, grayName, grayRule, srcIp, srcUser);
    }

    @Override
    public void removeConfigInfoGray(final String dataId, final String group, final String tenant, final String grayName, final String srcIp, final String srcUser) {
        this.tjt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
                String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName;
                try {
                    ConfigInfoGrayWrapper oldConfigAllInfo4Gray = ExternalConfigInfoGrayPersistServiceImpl.this.findConfigInfo4Gray(dataId, group, tenantTmp, grayNameTmp);
                    if (oldConfigAllInfo4Gray == null) {
                        return;
                    }
                    ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)ExternalConfigInfoGrayPersistServiceImpl.this.mapperManager.findMapper(ExternalConfigInfoGrayPersistServiceImpl.this.dataSourceService.getDataSourceType(), "config_info_gray");
                    ExternalConfigInfoGrayPersistServiceImpl.this.jt.update(configInfoGrayMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "gray_name")), new Object[]{dataId, group, tenantTmp, grayNameTmp});
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    ExternalConfigInfoGrayPersistServiceImpl.this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo4Gray.getId(), oldConfigAllInfo4Gray, srcIp, srcUser, now, "D", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(oldConfigAllInfo4Gray.getGrayName(), oldConfigAllInfo4Gray.getGrayRule(), oldConfigAllInfo4Gray.getSrcUser()));
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    @Override
    public ConfigOperateResult updateConfigInfo4Gray(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        return (ConfigOperateResult)this.tjt.execute(status -> {
            String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
            String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
            String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
            String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
            try {
                ConfigInfoGrayWrapper oldConfigAllInfo4Gray = this.findConfigInfo4Gray(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
                if (oldConfigAllInfo4Gray == null && LogUtil.FATAL_LOG.isErrorEnabled()) {
                    LogUtil.FATAL_LOG.error("expected config info[dataid:{}, group:{}, tenent:{}] but not found.", new Object[]{configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()});
                }
                String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
                ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
                this.jt.update(configInfoGrayMapper.update(Arrays.asList("content", "encrypted_data_key", "md5", "src_ip", "src_user", "gmt_modified@NOW()", "app_name", "gray_rule"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name")), new Object[]{configInfo.getContent(), configInfo.getEncryptedDataKey(), md5, srcIp, srcUser, appNameTmp, grayRuleTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                if (!PropertyUtil.GRAY_MIGRATE_FLAG.get().booleanValue()) {
                    this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo4Gray.getId(), oldConfigAllInfo4Gray, srcIp, srcUser, now, "U", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(oldConfigAllInfo4Gray.getGrayName(), oldConfigAllInfo4Gray.getGrayRule(), oldConfigAllInfo4Gray.getSrcUser()));
                }
                return this.getGrayOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
        });
    }

    @Override
    public ConfigOperateResult updateConfigInfo4GrayCas(ConfigInfo configInfo, String grayName, String grayRule, String srcIp, String srcUser) {
        return (ConfigOperateResult)this.tjt.execute(status -> {
            String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
            String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
            String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
            String grayRuleTmp = StringUtils.isBlank((CharSequence)grayRule) ? "" : grayRule.trim();
            try {
                String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
                ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
                MapperContext context = new MapperContext();
                context.putUpdateParameter("content", (Object)configInfo.getContent());
                context.putUpdateParameter("md5", (Object)md5);
                context.putUpdateParameter("srcIp", (Object)srcIp);
                context.putUpdateParameter("srcUser", (Object)srcUser);
                context.putUpdateParameter("app_name", (Object)appNameTmp);
                context.putWhereParameter("dataId", (Object)configInfo.getDataId());
                context.putWhereParameter("groupId", (Object)configInfo.getGroup());
                context.putWhereParameter("tenantId", (Object)tenantTmp);
                context.putWhereParameter("grayName", (Object)grayNameTmp);
                context.putWhereParameter("grayRule", (Object)grayRuleTmp);
                context.putWhereParameter("md5", (Object)configInfo.getMd5());
                MapperResult mapperResult = configInfoGrayMapper.updateConfigInfo4GrayCas(context);
                boolean success = this.jt.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) > 0;
                ConfigInfoGrayWrapper oldConfigAllInfo4Gray = this.findConfigInfo4Gray(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
                if (oldConfigAllInfo4Gray == null && LogUtil.FATAL_LOG.isErrorEnabled()) {
                    LogUtil.FATAL_LOG.error("expected config info[dataid:{}, group:{}, tenent:{}] but not found.", new Object[]{configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()});
                }
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigAllInfo4Gray.getId(), oldConfigAllInfo4Gray, srcIp, srcUser, now, "U", "gray", grayNameTmp, ConfigExtInfoUtil.getExtInfoFromGrayInfo(oldConfigAllInfo4Gray.getGrayName(), oldConfigAllInfo4Gray.getGrayRule(), oldConfigAllInfo4Gray.getSrcUser()));
                if (success) {
                    return this.getGrayOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, grayNameTmp);
                }
                return new ConfigOperateResult(false);
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
        });
    }

    @Override
    public ConfigInfoGrayWrapper findConfigInfo4Gray(String dataId, String group, String tenant, String grayName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String grayNameTmp = StringUtils.isBlank((CharSequence)grayName) ? "" : grayName.trim();
        try {
            ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            return (ConfigInfoGrayWrapper)this.jt.queryForObject(configInfoGrayMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gray_name", "gray_rule", "app_name", "content", "md5", "encrypted_data_key", "gmt_modified", "src_user"), Arrays.asList("data_id", "group_id", "tenant_id", "gray_name")), new Object[]{dataId, group, tenantTmp, grayNameTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoGrayCount() {
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sql = configInfoGrayMapper.count(null);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoGrayCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoGrayWrapper> findAllConfigInfoGrayForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String sqlCountRows = configInfoGrayMapper.count(null);
        MapperResult sqlFetchRows = configInfoGrayMapper.findAllConfigInfoGrayForDumpAllFetchRows(new MapperContext(startRow, pageSize));
        PaginationHelper helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfoGrayWrapper> findChangeConfig(Timestamp startTime, long lastMaxId, int pageSize) {
        try {
            ConfigInfoGrayMapper configInfoMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
            MapperContext context = new MapperContext();
            context.putWhereParameter("startTime", (Object)startTime);
            context.putWhereParameter("pageSize", (Object)pageSize);
            context.putWhereParameter("lastMaxId", (Object)lastMaxId);
            MapperResult mapperResult = configInfoMapper.findChangeConfig(context);
            return this.jt.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_GRAY_WRAPPER_ROW_MAPPER);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> findConfigInfoGrays(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoGrayMapper configInfoGrayMapper = (ConfigInfoGrayMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_gray");
        String selectSql = configInfoGrayMapper.select(Collections.singletonList("gray_name"), Arrays.asList("data_id", "group_id", "tenant_id"));
        return this.jt.queryForList(selectSql, new Object[]{dataId, group, tenantTmp}, String.class);
    }
}

