/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.cluster.ServerStatusManager;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.SwitchManager;
import com.alibaba.nacos.naming.model.form.UpdateSwitchForm;
import com.alibaba.nacos.naming.model.vo.MetricsInfoVo;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/ns/operator", "/v2/ns/ops"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class OperatorControllerV2 {
    private final SwitchManager switchManager;
    private final ServerStatusManager serverStatusManager;
    private final SwitchDomain switchDomain;
    private final ClientManager clientManager;

    public OperatorControllerV2(SwitchManager switchManager, ServerStatusManager serverStatusManager, SwitchDomain switchDomain, ClientManager clientManager) {
        this.switchManager = switchManager;
        this.serverStatusManager = serverStatusManager;
        this.switchDomain = switchDomain;
        this.clientManager = clientManager;
    }

    @GetMapping(value={"/switches"})
    public Result<SwitchDomain> switches() {
        return Result.success((Object)this.switchDomain);
    }

    @Secured(resource="naming/switches", action=ActionTypes.WRITE)
    @PutMapping(value={"/switches"})
    public Result<String> updateSwitch(UpdateSwitchForm updateSwitchForm) throws Exception {
        updateSwitchForm.validate();
        try {
            this.switchManager.update(updateSwitchForm.getEntry(), updateSwitchForm.getValue(), updateSwitchForm.getDebug());
        }
        catch (IllegalArgumentException e) {
            throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.SERVER_ERROR, e.getMessage());
        }
        return Result.success((Object)"ok");
    }

    @GetMapping(value={"/metrics"})
    public Result<MetricsInfoVo> metrics(@RequestParam(value="onlyStatus", required=false, defaultValue="true") Boolean onlyStatus) {
        MetricsInfoVo metricsInfoVo = new MetricsInfoVo();
        metricsInfoVo.setStatus(this.serverStatusManager.getServerStatus().name());
        if (onlyStatus.booleanValue()) {
            return Result.success((Object)metricsInfoVo);
        }
        int connectionBasedClient = 0;
        int ephemeralIpPortClient = 0;
        int persistentIpPortClient = 0;
        int responsibleClientCount = 0;
        Collection<String> allClientId = this.clientManager.allClientId();
        for (String clientId : allClientId) {
            if (clientId.contains("#")) {
                if (clientId.endsWith("false")) {
                    ++persistentIpPortClient;
                } else {
                    ++ephemeralIpPortClient;
                }
            } else {
                ++connectionBasedClient;
            }
            if (!this.clientManager.isResponsibleClient(this.clientManager.getClient(clientId))) continue;
            ++responsibleClientCount;
        }
        metricsInfoVo.setServiceCount(MetricsMonitor.getDomCountMonitor().get());
        metricsInfoVo.setInstanceCount(MetricsMonitor.getIpCountMonitor().get());
        metricsInfoVo.setSubscribeCount(MetricsMonitor.getSubscriberCount().get());
        metricsInfoVo.setClientCount(allClientId.size());
        metricsInfoVo.setConnectionBasedClientCount(connectionBasedClient);
        metricsInfoVo.setEphemeralIpPortClientCount(ephemeralIpPortClient);
        metricsInfoVo.setPersistentIpPortClientCount(persistentIpPortClient);
        metricsInfoVo.setResponsibleClientCount(responsibleClientCount);
        metricsInfoVo.setCpu(Float.valueOf(EnvUtil.getCpu()));
        metricsInfoVo.setLoad(Float.valueOf(EnvUtil.getLoad()));
        metricsInfoVo.setMem(Float.valueOf(EnvUtil.getMem()));
        return Result.success((Object)metricsInfoVo);
    }
}

