/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.manager.impl;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.v2.DistroClientVerifyInfo;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.factory.ClientFactory;
import com.alibaba.nacos.naming.core.v2.client.factory.ClientFactoryHolder;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component(value="persistentIpPortClientManager")
public class PersistentIpPortClientManager
implements ClientManager {
    private final ClientFactory<IpPortBasedClient> clientFactory;
    private ConcurrentMap<String, IpPortBasedClient> clients = new ConcurrentHashMap<String, IpPortBasedClient>();

    public PersistentIpPortClientManager() {
        this.clientFactory = ClientFactoryHolder.getInstance().findClientFactory("persistentIpPort");
    }

    @Override
    public boolean clientConnected(String clientId, ClientAttributes attributes) {
        return this.clientConnected(this.clientFactory.newClient(clientId, attributes));
    }

    @Override
    public boolean clientConnected(Client client) {
        this.clients.computeIfAbsent(client.getClientId(), s -> {
            Loggers.SRV_LOG.info("Client connection {} connect", (Object)client.getClientId());
            IpPortBasedClient ipPortBasedClient = (IpPortBasedClient)client;
            ipPortBasedClient.init();
            return ipPortBasedClient;
        });
        return true;
    }

    @Override
    public boolean syncClientConnected(String clientId, ClientAttributes attributes) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public boolean clientDisconnected(String clientId) {
        Loggers.SRV_LOG.info("Persistent client connection {} disconnect", (Object)clientId);
        IpPortBasedClient client = (IpPortBasedClient)this.clients.remove(clientId);
        if (null == client) {
            return true;
        }
        boolean isResponsible = this.isResponsibleClient(client);
        NotifyCenter.publishEvent((Event)new ClientEvent.ClientDisconnectEvent(client, isResponsible));
        client.release();
        NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientReleaseEvent(client, isResponsible));
        return true;
    }

    @Override
    public Client getClient(String clientId) {
        return (Client)this.clients.get(clientId);
    }

    @Override
    public boolean contains(String clientId) {
        return this.clients.containsKey(clientId);
    }

    @Override
    public Collection<String> allClientId() {
        HashSet<String> clientIds = new HashSet<String>(this.clients.size());
        clientIds.addAll(this.clients.keySet());
        return clientIds;
    }

    @Override
    public boolean isResponsibleClient(Client client) {
        return true;
    }

    @Override
    public boolean verifyClient(DistroClientVerifyInfo verifyData) {
        throw new UnsupportedOperationException("");
    }

    public Map<String, IpPortBasedClient> showClients() {
        return Collections.unmodifiableMap(this.clients);
    }

    public void loadFromSnapshot(ConcurrentMap<String, IpPortBasedClient> clients) {
        ConcurrentMap<String, IpPortBasedClient> oldClients = this.clients;
        this.clients = clients;
        oldClients.clear();
    }

    public void addSyncClient(IpPortBasedClient client) {
        this.clients.put(client.getClientId(), client);
    }

    public void removeAndRelease(String clientId) {
        IpPortBasedClient client = (IpPortBasedClient)this.clients.remove(clientId);
        if (client != null) {
            client.release();
        }
    }
}

