/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.pojo;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class Service
implements Serializable {
    private static final long serialVersionUID = -990509089519499344L;
    private final String namespace;
    private final String group;
    private final String name;
    private final boolean ephemeral;
    private final AtomicLong revision;
    private long lastUpdatedTime;

    private Service(String namespace, String group, String name, boolean ephemeral) {
        this.namespace = namespace;
        this.group = group;
        this.name = name;
        this.ephemeral = ephemeral;
        this.revision = new AtomicLong();
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public static Service newService(String namespace, String group, String name) {
        return Service.newService(namespace, group, name, true);
    }

    public static Service newService(String namespace, String group, String name, boolean ephemeral) {
        return new Service(namespace, group, name, ephemeral);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public long getRevision() {
        return this.revision.get();
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void renewUpdateTime() {
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public void incrementRevision() {
        this.revision.incrementAndGet();
    }

    public String getGroupedServiceName() {
        return NamingUtils.getGroupedName((String)this.name, (String)this.group);
    }

    public String getNameSpaceGroupedServiceName() {
        return this.namespace + "@@" + NamingUtils.getGroupedName((String)this.name, (String)this.group);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Service)) {
            return false;
        }
        Service service = (Service)o;
        return this.namespace.equals(service.namespace) && this.group.equals(service.group) && this.name.equals(service.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.group, this.name);
    }

    public String toString() {
        return "Service{namespace='" + this.namespace + '\'' + ", group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", ephemeral=" + this.ephemeral + ", revision=" + this.revision + '}';
    }
}

