/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.extend;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.naming.healthcheck.extend.AbstractHealthCheckProcessorExtend;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckProcessorV2;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckProcessorExtendV2
extends AbstractHealthCheckProcessorExtend {
    private final Collection<HealthCheckProcessorV2> processors = NacosServiceLoader.load(HealthCheckProcessorV2.class);

    @Override
    public Set<String> addProcessor(Set<String> origin) {
        Iterator<HealthCheckProcessorV2> processorIt = this.processors.iterator();
        HashSet<String> processorType = new HashSet<String>(origin);
        while (processorIt.hasNext()) {
            HealthCheckProcessorV2 processor = processorIt.next();
            String type = processor.getType();
            if (processorType.contains(type)) {
                throw new RuntimeException("More than one processor of the same type was found : [type=\"" + type + "\"]");
            }
            processorType.add(type);
            this.registry.registerSingleton(this.lowerFirstChar(processor.getClass().getSimpleName()), (Object)processor);
        }
        return processorType;
    }
}

