/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.utils.ByteUtils;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.TypeUtils;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.persistent.impl.BatchReadResponse;
import com.alibaba.nacos.naming.consistency.persistent.impl.BatchWriteRequest;
import com.alibaba.nacos.naming.consistency.persistent.impl.OldDataOperation;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.SwitchDomainSnapshotOperation;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SwitchManager
extends RequestProcessor4CP {
    private final SwitchDomain switchDomain;
    private final ProtocolManager protocolManager;
    private final ReentrantReadWriteLock raftLock;
    private final ReentrantLock requestLock;
    private final Serializer serializer;
    private final SwitchDomainSnapshotOperation snapshotOperation;
    private final File dataFile;

    public SwitchManager(SwitchDomain switchDomain, ProtocolManager protocolManager) {
        this.switchDomain = switchDomain;
        this.protocolManager = protocolManager;
        this.raftLock = new ReentrantReadWriteLock();
        this.requestLock = new ReentrantLock();
        this.serializer = SerializeFactory.getSerializer((String)"JSON");
        this.snapshotOperation = new SwitchDomainSnapshotOperation(this.raftLock, this, this.serializer);
        this.dataFile = Paths.get(UtilsAndCommons.DATA_BASE_DIR, "data", KeyBuilder.getSwitchDomainKey()).toFile();
        try {
            DiskUtils.forceMkdir((String)this.dataFile.getParent());
        }
        catch (IOException e) {
            Loggers.RAFT.error("Init Switch Domain directory failed: ", (Throwable)e);
        }
        protocolManager.getCpProtocol().addRequestProcessors(Collections.singletonList(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String entry, String value, boolean debug) throws Exception {
        this.requestLock.lock();
        try {
            SwitchDomain tempSwitchDomain = this.switchDomain.clone();
            if (entry.equals("distroThreshold")) {
                float threshold = Float.parseFloat(value);
                if (threshold <= 0.0f) {
                    throw new IllegalArgumentException("distroThreshold can not be zero or negative: " + threshold);
                }
                tempSwitchDomain.setDistroThreshold(threshold);
            }
            if (entry.equals("clientBeatInterval")) {
                long clientBeatInterval = Long.parseLong(value);
                tempSwitchDomain.setClientBeatInterval(clientBeatInterval);
            }
            if (entry.equals("pushVersion")) {
                String type = value.split(":")[0];
                String version = value.split(":")[1];
                if (!version.matches("[0-9]+\\.[0-9]+\\.[0-9]+")) {
                    throw new IllegalArgumentException("illegal version, must match: [0-9]+\\.[0-9]+\\.[0-9]+");
                }
                if (StringUtils.equals((String)"java", (String)type)) {
                    tempSwitchDomain.setPushJavaVersion(version);
                } else if (StringUtils.equals((String)"python", (String)type)) {
                    tempSwitchDomain.setPushPythonVersion(version);
                } else if (StringUtils.equals((String)"c", (String)type)) {
                    tempSwitchDomain.setPushCVersion(version);
                } else if (StringUtils.equals((String)"go", (String)type)) {
                    tempSwitchDomain.setPushGoVersion(version);
                } else if (StringUtils.equals((String)"csharp", (String)type)) {
                    tempSwitchDomain.setPushCSharpVersion(version);
                } else {
                    throw new IllegalArgumentException("unsupported client type: " + type);
                }
            }
            if (entry.equals("pushCacheMillis")) {
                long cacheMillis = Long.parseLong(value);
                if (cacheMillis < 10000L) {
                    throw new IllegalArgumentException("min cache time for http or tcp is too small(<10000)");
                }
                tempSwitchDomain.setDefaultPushCacheMillis(cacheMillis);
            }
            if (entry.equals("defaultCacheMillis")) {
                long cacheMillis = Long.parseLong(value);
                if (cacheMillis < 1000L) {
                    throw new IllegalArgumentException("min default cache time  is too small(<1000)");
                }
                tempSwitchDomain.setDefaultCacheMillis(cacheMillis);
            }
            if (entry.equals("masters")) {
                List<String> masters = Arrays.asList(value.split(","));
                tempSwitchDomain.setMasters(masters);
            }
            if (entry.equals("distro")) {
                boolean enabled = Boolean.parseBoolean(value);
                tempSwitchDomain.setDistroEnabled(enabled);
            }
            if (entry.equals("check")) {
                boolean enabled = Boolean.parseBoolean(value);
                tempSwitchDomain.setHealthCheckEnabled(enabled);
            }
            if (entry.equals("pushEnabled")) {
                boolean enabled = Boolean.parseBoolean(value);
                tempSwitchDomain.setPushEnabled(enabled);
            }
            if (entry.equals("serviceStatusSynchronizationPeriodMillis")) {
                long millis = Long.parseLong(value);
                if (millis < 5000L) {
                    throw new IllegalArgumentException("serviceStatusSynchronizationPeriodMillis is too small(<5000)");
                }
                tempSwitchDomain.setServiceStatusSynchronizationPeriodMillis(millis);
            }
            if (entry.equals("serverStatusSynchronizationPeriodMillis")) {
                long millis = Long.parseLong(value);
                if (millis < 1000L) {
                    throw new IllegalArgumentException("serverStatusSynchronizationPeriodMillis is too small(<15000)");
                }
                tempSwitchDomain.setServerStatusSynchronizationPeriodMillis(millis);
            }
            if (entry.equals("healthCheckTimes")) {
                int times = Integer.parseInt(value);
                tempSwitchDomain.setCheckTimes(times);
            }
            if (entry.equals("disableAddIP")) {
                boolean disableAddIp = Boolean.parseBoolean(value);
                tempSwitchDomain.setDisableAddIP(disableAddIp);
            }
            if (entry.equals("sendBeatOnly")) {
                boolean sendBeatOnly = Boolean.parseBoolean(value);
                tempSwitchDomain.setSendBeatOnly(sendBeatOnly);
            }
            if (entry.equals("limitedUrlMap")) {
                HashMap<String, Integer> limitedUrlMap = new HashMap<String, Integer>(16);
                if (!StringUtils.isEmpty((String)value)) {
                    String[] entries;
                    for (String each : entries = value.split(",")) {
                        String[] parts = each.split(":");
                        if (parts.length < 2) {
                            throw new IllegalArgumentException("invalid input for limited urls");
                        }
                        String limitedUrl = parts[0];
                        if (StringUtils.isEmpty((String)limitedUrl)) {
                            throw new IllegalArgumentException("url can not be empty, url: " + limitedUrl);
                        }
                        int statusCode = Integer.parseInt(parts[1]);
                        if (statusCode <= 0) {
                            throw new IllegalArgumentException("illegal normal status code: " + statusCode);
                        }
                        limitedUrlMap.put(limitedUrl, statusCode);
                    }
                    tempSwitchDomain.setLimitedUrlMap(limitedUrlMap);
                }
            }
            if (entry.equals("enableStandalone") && !StringUtils.isNotEmpty((String)value)) {
                tempSwitchDomain.setEnableStandalone(Boolean.parseBoolean(value));
            }
            if (entry.equals("overriddenServerStatus")) {
                String status = value;
                if ("null".equals(status)) {
                    status = "";
                }
                tempSwitchDomain.setOverriddenServerStatus(status);
            }
            if (entry.equals("defaultInstanceEphemeral")) {
                tempSwitchDomain.setDefaultInstanceEphemeral(Boolean.parseBoolean(value));
            }
            if (entry.equals("distroServerExpiredMillis")) {
                tempSwitchDomain.setDistroServerExpiredMillis(Long.parseLong(value));
            }
            if (entry.equals("lightBeatEnabled")) {
                tempSwitchDomain.setLightBeatEnabled(ConvertUtils.toBoolean((String)value));
            }
            if (entry.equals("autoChangeHealthCheckEnabled")) {
                tempSwitchDomain.setAutoChangeHealthCheckEnabled(ConvertUtils.toBoolean((String)value));
            }
            try {
                if ("httpHealthParams".equals(entry)) {
                    SwitchDomain.HttpHealthParams httpHealthParams = (SwitchDomain.HttpHealthParams)JacksonUtils.toObj((String)value, SwitchDomain.HttpHealthParams.class);
                    tempSwitchDomain.setHttpHealthParams(httpHealthParams);
                    this.validateHealthParams(httpHealthParams);
                }
                if ("tcpHealthParams".equals(entry)) {
                    SwitchDomain.TcpHealthParams tcpHealthParams = (SwitchDomain.TcpHealthParams)JacksonUtils.toObj((String)value, SwitchDomain.TcpHealthParams.class);
                    tempSwitchDomain.setTcpHealthParams(tcpHealthParams);
                    this.validateHealthParams(tcpHealthParams);
                }
                if ("mysqlHealthParams".equals(entry)) {
                    tempSwitchDomain.setMysqlHealthParams((SwitchDomain.MysqlHealthParams)JacksonUtils.toObj((String)value, SwitchDomain.MysqlHealthParams.class));
                }
            }
            catch (NacosDeserializationException e) {
                throw new IllegalArgumentException("json param invalid.");
            }
            if (debug) {
                this.update(tempSwitchDomain);
            } else {
                this.updateWithConsistency(tempSwitchDomain);
            }
        }
        finally {
            this.requestLock.unlock();
        }
    }

    public void update(SwitchDomain newSwitchDomain) {
        this.switchDomain.setMasters(newSwitchDomain.getMasters());
        this.switchDomain.setAdWeightMap(newSwitchDomain.getAdWeightMap());
        this.switchDomain.setDefaultPushCacheMillis(newSwitchDomain.getDefaultPushCacheMillis());
        this.switchDomain.setClientBeatInterval(newSwitchDomain.getClientBeatInterval());
        this.switchDomain.setDefaultCacheMillis(newSwitchDomain.getDefaultCacheMillis());
        this.switchDomain.setDistroThreshold(newSwitchDomain.getDistroThreshold());
        this.switchDomain.setHealthCheckEnabled(newSwitchDomain.isHealthCheckEnabled());
        this.switchDomain.setAutoChangeHealthCheckEnabled(newSwitchDomain.isAutoChangeHealthCheckEnabled());
        this.switchDomain.setDistroEnabled(newSwitchDomain.isDistroEnabled());
        this.switchDomain.setPushEnabled(newSwitchDomain.isPushEnabled());
        this.switchDomain.setEnableStandalone(newSwitchDomain.isEnableStandalone());
        this.switchDomain.setCheckTimes(newSwitchDomain.getCheckTimes());
        this.switchDomain.setHttpHealthParams(newSwitchDomain.getHttpHealthParams());
        this.switchDomain.setTcpHealthParams(newSwitchDomain.getTcpHealthParams());
        this.switchDomain.setMysqlHealthParams(newSwitchDomain.getMysqlHealthParams());
        this.switchDomain.setIncrementalList(newSwitchDomain.getIncrementalList());
        this.switchDomain.setServerStatusSynchronizationPeriodMillis(newSwitchDomain.getServerStatusSynchronizationPeriodMillis());
        this.switchDomain.setServiceStatusSynchronizationPeriodMillis(newSwitchDomain.getServiceStatusSynchronizationPeriodMillis());
        this.switchDomain.setDisableAddIP(newSwitchDomain.isDisableAddIP());
        this.switchDomain.setSendBeatOnly(newSwitchDomain.isSendBeatOnly());
        this.switchDomain.setLimitedUrlMap(newSwitchDomain.getLimitedUrlMap());
        this.switchDomain.setDistroServerExpiredMillis(newSwitchDomain.getDistroServerExpiredMillis());
        this.switchDomain.setPushGoVersion(newSwitchDomain.getPushGoVersion());
        this.switchDomain.setPushJavaVersion(newSwitchDomain.getPushJavaVersion());
        this.switchDomain.setPushPythonVersion(newSwitchDomain.getPushPythonVersion());
        this.switchDomain.setPushCVersion(newSwitchDomain.getPushCVersion());
        this.switchDomain.setPushCSharpVersion(newSwitchDomain.getPushCSharpVersion());
        this.switchDomain.setEnableAuthentication(newSwitchDomain.isEnableAuthentication());
        this.switchDomain.setOverriddenServerStatus(newSwitchDomain.getOverriddenServerStatus());
        this.switchDomain.setDefaultInstanceEphemeral(newSwitchDomain.isDefaultInstanceEphemeral());
        this.switchDomain.setLightBeatEnabled(newSwitchDomain.isLightBeatEnabled());
    }

    public void validateHealthParams(SwitchDomain.HealthParams healthParams) {
        if (healthParams.getMin() < 500) {
            throw new IllegalArgumentException("min check time for http or tcp is too small(<500)");
        }
        if (healthParams.getMax() < 3000) {
            throw new IllegalArgumentException("max check time for http or tcp is too small(<3000)");
        }
        if (healthParams.getFactor() < 0.0f || healthParams.getFactor() > 1.0f) {
            throw new IllegalArgumentException("malformed factor");
        }
    }

    private void updateWithConsistency(SwitchDomain tempSwitchDomain) throws NacosException {
        try {
            BatchWriteRequest req = new BatchWriteRequest();
            String switchDomainKey = KeyBuilder.getSwitchDomainKey();
            Datum datum = Datum.createDatum(switchDomainKey, tempSwitchDomain);
            req.append(ByteUtils.toBytes((String)switchDomainKey), this.serializer.serialize((Object)datum));
            WriteRequest operationLog = WriteRequest.newBuilder().setGroup(this.group()).setOperation(OldDataOperation.Write.getDesc()).setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)req))).build();
            this.protocolManager.getCpProtocol().write(operationLog);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Submit switch domain failed: ", (Throwable)e);
            throw new NacosException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
        }
    }

    public SwitchDomain getSwitchDomain() {
        return this.switchDomain;
    }

    public List<SnapshotOperation> loadSnapshotOperate() {
        return Collections.singletonList(this.snapshotOperation);
    }

    public void loadSnapshot(String snapshotPath) {
        this.raftLock.writeLock().lock();
        try {
            File srcDir = Paths.get(snapshotPath, new String[0]).toFile();
            if (srcDir.exists()) {
                Object value;
                String baseDir = this.dataFile.getParent();
                DiskUtils.deleteDirThenMkdir((String)baseDir);
                File descDir = Paths.get(baseDir, new String[0]).toFile();
                DiskUtils.copyDirectory((File)srcDir, (File)descDir);
                if (!this.dataFile.exists()) {
                    return;
                }
                byte[] snapshotData = DiskUtils.readFileBytes((File)this.dataFile);
                Datum datum = (Datum)this.serializer.deserialize(snapshotData, this.getDatumType());
                Object v0 = value = null != datum ? datum.value : null;
                if (!(value instanceof SwitchDomain)) {
                    return;
                }
                this.update(value);
            }
        }
        catch (IOException e) {
            throw new NacosRuntimeException(ErrorCode.IOCopyDirError.getCode(), (Throwable)e);
        }
        finally {
            this.raftLock.writeLock().unlock();
        }
    }

    public void dumpSnapshot(String backupPath) {
        this.raftLock.writeLock().lock();
        try {
            File srcDir = Paths.get(this.dataFile.getParent(), new String[0]).toFile();
            File descDir = Paths.get(backupPath, new String[0]).toFile();
            DiskUtils.copyDirectory((File)srcDir, (File)descDir);
        }
        catch (IOException e) {
            throw new NacosRuntimeException(ErrorCode.IOCopyDirError.getCode(), (Throwable)e);
        }
        finally {
            this.raftLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onRequest(ReadRequest request) {
        this.raftLock.readLock().lock();
        try {
            List keys = (List)this.serializer.deserialize(request.getData().toByteArray(), (Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{byte[].class}));
            if (this.isNotSwitchDomainKey(keys)) {
                Response response = Response.newBuilder().setSuccess(false).setErrMsg("not switch domain key").build();
                return response;
            }
            Datum datum = Datum.createDatum(KeyBuilder.getSwitchDomainKey(), this.switchDomain);
            BatchReadResponse response = new BatchReadResponse();
            response.append(ByteUtils.toBytes((String)KeyBuilder.getSwitchDomainKey()), this.serializer.serialize((Object)datum));
            Response response2 = Response.newBuilder().setSuccess(true).setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)response))).build();
            return response2;
        }
        catch (Exception e) {
            Loggers.RAFT.warn("On read switch domain failed, ", (Throwable)e);
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(e.getMessage()).build();
            return response;
        }
        finally {
            this.raftLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onApply(WriteRequest log) {
        this.raftLock.writeLock().lock();
        try {
            Object value;
            BatchWriteRequest bwRequest = (BatchWriteRequest)this.serializer.deserialize(log.getData().toByteArray(), BatchWriteRequest.class);
            if (this.isNotSwitchDomainKey(bwRequest.getKeys())) {
                Response response = Response.newBuilder().setSuccess(false).setErrMsg("not switch domain key").build();
                return response;
            }
            Datum datum = (Datum)this.serializer.deserialize(bwRequest.getValues().get(0), this.getDatumType());
            Object v0 = value = null != datum ? datum.value : null;
            if (!(value instanceof SwitchDomain)) {
                Response response = Response.newBuilder().setSuccess(false).setErrMsg("datum is not switch domain").build();
                return response;
            }
            DiskUtils.touch((File)this.dataFile);
            DiskUtils.writeFile((File)this.dataFile, (byte[])bwRequest.getValues().get(0), (boolean)false);
            SwitchDomain switchDomain = value;
            this.update(switchDomain);
            Response response = Response.newBuilder().setSuccess(true).build();
            return response;
        }
        catch (Exception e) {
            Loggers.RAFT.warn("On apply switch domain failed, ", (Throwable)e);
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(e.getMessage()).build();
            return response;
        }
        finally {
            this.raftLock.writeLock().unlock();
        }
    }

    public String group() {
        return "naming_persistent_service";
    }

    private boolean isNotSwitchDomainKey(List<byte[]> keys) {
        if (1 != keys.size()) {
            return false;
        }
        String keyString = new String(keys.get(0));
        return !KeyBuilder.getSwitchDomainKey().equals(keyString);
    }

    private Type getDatumType() {
        return TypeUtils.parameterize(Datum.class, (Type[])new Type[]{SwitchDomain.class});
    }
}

