/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.configuration;

import com.alibaba.nacos.persistence.utils.DatasourcePlatformUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class DatasourceConfiguration
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public static boolean useExternalDB = false;
    public static boolean embeddedStorage = EnvUtil.getStandaloneMode();

    public static boolean isUseExternalDB() {
        return useExternalDB;
    }

    public static void setUseExternalDB(boolean useExternalDB) {
        DatasourceConfiguration.useExternalDB = useExternalDB;
    }

    public static boolean isEmbeddedStorage() {
        return embeddedStorage;
    }

    public static void setEmbeddedStorage(boolean embeddedStorage) {
        DatasourceConfiguration.embeddedStorage = embeddedStorage;
    }

    private void loadDatasourceConfiguration() {
        String platform = DatasourcePlatformUtil.getDatasourcePlatform("");
        boolean useExternalStorage = !"".equalsIgnoreCase(platform) && !"derby".equalsIgnoreCase(platform);
        DatasourceConfiguration.setUseExternalDB(useExternalStorage);
        if (DatasourceConfiguration.isUseExternalDB()) {
            DatasourceConfiguration.setEmbeddedStorage(false);
        } else {
            boolean embeddedStorage = DatasourceConfiguration.isEmbeddedStorage() || Boolean.getBoolean("embeddedStorage");
            DatasourceConfiguration.setEmbeddedStorage(embeddedStorage);
            if (!embeddedStorage) {
                DatasourceConfiguration.setUseExternalDB(true);
            }
        }
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.loadDatasourceConfiguration();
    }
}

