/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.repository.extrnal;

import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ExternalStoragePaginationHelperImpl<E>
implements PaginationHelper<E> {
    private final JdbcTemplate jdbcTemplate;

    public ExternalStoragePaginationHelperImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.fetchPage(sqlCountRows, sqlFetchRows, args, pageNo, pageSize, (Long)null, rowMapper);
    }

    @Override
    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, Long lastMaxId, RowMapper rowMapper) {
        return this.doFetchPage(sqlCountRows, args, sqlFetchRows, args, pageNo, pageSize, rowMapper);
    }

    @Override
    public Page<E> fetchPageLimit(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.doFetchPage(sqlCountRows, null, sqlFetchRows, args, pageNo, pageSize, rowMapper);
    }

    @Override
    public Page fetchPageLimit(MapperResult countMapperResult, MapperResult mapperResult, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.fetchPageLimit(countMapperResult.getSql(), countMapperResult.getParamList().toArray(), mapperResult.getSql(), mapperResult.getParamList().toArray(), pageNo, pageSize, rowMapper);
    }

    @Override
    public Page<E> fetchPageLimit(String sqlCountRows, Object[] args1, String sqlFetchRows, Object[] args2, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.doFetchPage(sqlCountRows, args1, sqlFetchRows, args2, pageNo, pageSize, rowMapper);
    }

    @Override
    public Page<E> fetchPageLimit(String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        this.checkPageInfo(pageNo, pageSize);
        Page page = new Page();
        List result = this.jdbcTemplate.query(sqlFetchRows, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public void updateLimit(String sql, Object[] args) {
        try {
            this.jdbcTemplate.update(sql, args);
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    private void checkPageInfo(int pageNo, int pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
    }

    private Page<E> doFetchPage(String sqlCountRows, Object[] countAgrs, String sqlFetchRows, Object[] fetchArgs, int pageNo, int pageSize, RowMapper rowMapper) {
        this.checkPageInfo(pageNo, pageSize);
        Integer rowCountInt = null;
        rowCountInt = null != countAgrs ? (Integer)this.jdbcTemplate.queryForObject(sqlCountRows, countAgrs, Integer.class) : (Integer)this.jdbcTemplate.queryForObject(sqlCountRows, Integer.class);
        if (null == rowCountInt) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        List result = this.jdbcTemplate.query(sqlFetchRows, fetchArgs, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }
}

