/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.utils;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class PersistenceExecutor {
    private static final ScheduledExecutorService TIMER_EXECUTOR = ExecutorFactory.Managed.newScheduledExecutorService((String)PersistenceExecutor.class.getCanonicalName(), (int)2, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.persistence.timer"));
    private static final Executor DUMP_EXECUTOR = ExecutorFactory.Managed.newSingleExecutorService((String)PersistenceExecutor.class.getCanonicalName(), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.persistence.embedded.dump"));
    private static final ExecutorService EMBEDDED_SNAPSHOT_EXECUTOR = ExecutorFactory.Managed.newSingleExecutorService((String)PersistenceExecutor.class.getCanonicalName(), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.persistence.embedded.snapshot"));

    public static void scheduleTask(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        TIMER_EXECUTOR.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public static void executeEmbeddedDump(Runnable runnable) {
        DUMP_EXECUTOR.execute(runnable);
    }

    public static void executeSnapshot(Runnable runnable) {
        EMBEDDED_SNAPSHOT_EXECUTOR.execute(runnable);
    }
}

