/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.prometheus.exception;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.model.v2.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Order(value=-1)
@ControllerAdvice(basePackages={"com.alibaba.nacos.prometheus.controller"})
@ResponseBody
public class PrometheusApiExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusApiExceptionHandler.class);

    @ExceptionHandler(value={NacosException.class})
    public ResponseEntity<Result<String>> handleNacosException(NacosException e) {
        LOGGER.error("got exception. {}", (Object)e.getErrMsg());
        return ResponseEntity.internalServerError().body((Object)Result.failure((String)e.getErrMsg()));
    }

    @ExceptionHandler(value={NacosRuntimeException.class})
    public ResponseEntity<Result<String>> handleNacosRuntimeException(NacosRuntimeException e) {
        LOGGER.error("got exception. {}", (Object)e.getMessage());
        return ResponseEntity.status((int)e.getErrCode()).body((Object)Result.failure((String)e.getMessage()));
    }
}

