/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.bulkhead.monitoring.endpoint;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.common.bulkhead.monitoring.endpoint.BulkheadEventDTOFactory;
import io.github.resilience4j.common.bulkhead.monitoring.endpoint.BulkheadEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="bulkheadevents")
public class BulkheadEventsEndpoint {
    private final EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry;

    public BulkheadEventsEndpoint(EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @ReadOperation
    public BulkheadEventsEndpointResponse getAllBulkheadEvents() {
        List response = this.eventConsumerRegistry.getAllEventConsumer().stream().flatMap(CircularEventConsumer::getBufferedEventsStream).sorted(Comparator.comparing(BulkheadEvent::getCreationTime)).map(BulkheadEventDTOFactory::createBulkheadEventDTO).collect(Collectors.toList());
        return new BulkheadEventsEndpointResponse(response);
    }

    @ReadOperation
    public BulkheadEventsEndpointResponse getEventsFilteredByBulkheadName(@Selector String bulkheadName) {
        List response = this.getBulkheadEvent(bulkheadName).stream().map(BulkheadEventDTOFactory::createBulkheadEventDTO).collect(Collectors.toList());
        return new BulkheadEventsEndpointResponse(response);
    }

    @ReadOperation
    public BulkheadEventsEndpointResponse getEventsFilteredByBulkheadNameAndEventType(@Selector String bulkheadName, @Selector String eventType) {
        List response = this.getBulkheadEvent(bulkheadName).stream().filter(event -> event.getEventType() == BulkheadEvent.Type.valueOf((String)eventType.toUpperCase())).map(BulkheadEventDTOFactory::createBulkheadEventDTO).collect(Collectors.toList());
        return new BulkheadEventsEndpointResponse(response);
    }

    private List<BulkheadEvent> getBulkheadEvent(String bulkheadName) {
        CircularEventConsumer eventConsumer = this.eventConsumerRegistry.getEventConsumer(bulkheadName);
        if (eventConsumer == null) {
            CircularEventConsumer threadPoolEventConsumer = this.eventConsumerRegistry.getEventConsumer(String.join((CharSequence)"-", ThreadPoolBulkhead.class.getSimpleName(), bulkheadName));
            if (threadPoolEventConsumer != null) {
                return threadPoolEventConsumer.getBufferedEventsStream().filter(event -> event.getBulkheadName().equals(bulkheadName)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        return eventConsumer.getBufferedEventsStream().filter(event -> event.getBulkheadName().equals(bulkheadName)).collect(Collectors.toList());
    }
}

