/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.fallback;

import io.github.resilience4j.core.functions.CheckedSupplier;
import io.github.resilience4j.spring6.fallback.FallbackDecorator;
import io.github.resilience4j.spring6.fallback.FallbackMethod;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class CompletionStageFallbackDecorator
implements FallbackDecorator {
    @Override
    public boolean supports(Class<?> target) {
        return CompletionStage.class.isAssignableFrom(target);
    }

    @Override
    public CheckedSupplier<Object> decorate(FallbackMethod fallbackMethod, CheckedSupplier<Object> supplier) {
        return supplier.andThen(request -> {
            CompletionStage completionStage = (CompletionStage)request;
            CompletableFuture promise = new CompletableFuture();
            completionStage.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof CompletionException || throwable instanceof ExecutionException) {
                        this.tryRecover(fallbackMethod, promise, throwable.getCause());
                    } else {
                        this.tryRecover(fallbackMethod, promise, (Throwable)throwable);
                    }
                } else {
                    promise.complete(result);
                }
            });
            return promise;
        });
    }

    private void tryRecover(FallbackMethod fallbackMethod, CompletableFuture<Object> promise, Throwable throwable) {
        try {
            CompletionStage completionStage = (CompletionStage)fallbackMethod.fallback(throwable);
            Objects.requireNonNull(completionStage).whenComplete((fallbackResult, fallbackThrowable) -> {
                if (fallbackThrowable != null) {
                    promise.completeExceptionally((Throwable)fallbackThrowable);
                } else {
                    promise.complete(fallbackResult);
                }
            });
        }
        catch (Throwable fallbackThrowable2) {
            promise.completeExceptionally(fallbackThrowable2);
        }
    }
}

