/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.decoder;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.smartboot.socket.extension.decoder.SmartDecoder;

public class DelimiterFrameDecoder
implements SmartDecoder {
    private final int reposition;
    private final List<ByteBuffer> bufferList;
    private byte[] endFLag;
    private int exceptIndex;
    private boolean finishRead;
    private int position;

    public DelimiterFrameDecoder(byte[] endFLag, int unitBufferSize) {
        if (endFLag == null || endFLag.length == 0) {
            throw new IllegalArgumentException("endFLag cannot be empty");
        }
        if (unitBufferSize < 1) {
            throw new IllegalArgumentException("unitBufferSize Must be greater than 1");
        }
        this.endFLag = endFLag;
        int p = 0;
        for (int i = 1; i < endFLag.length; ++i) {
            if (endFLag[i] == endFLag[0]) continue;
            p = i - 1;
            break;
        }
        this.reposition = p;
        this.bufferList = new ArrayList<ByteBuffer>();
        this.bufferList.add(ByteBuffer.allocate(unitBufferSize));
    }

    @Override
    public boolean decode(ByteBuffer byteBuffer) {
        if (this.finishRead) {
            throw new RuntimeException("delimiter has finish read");
        }
        ByteBuffer preBuffer = this.bufferList.get(this.position);
        while (byteBuffer.hasRemaining()) {
            if (!preBuffer.hasRemaining()) {
                preBuffer.flip();
                ++this.position;
                if (this.position < this.bufferList.size()) {
                    preBuffer = this.bufferList.get(this.position);
                    preBuffer.clear();
                } else {
                    preBuffer = ByteBuffer.allocate(preBuffer.capacity());
                    this.bufferList.add(preBuffer);
                }
            }
            byte data = byteBuffer.get();
            preBuffer.put(data);
            if (data != this.endFLag[this.exceptIndex]) {
                if (this.exceptIndex == this.reposition + 1 && data == this.endFLag[this.reposition]) continue;
                this.exceptIndex = this.endFLag[0] == data ? 1 : 0;
                continue;
            }
            if (++this.exceptIndex != this.endFLag.length) continue;
            preBuffer.flip();
            this.finishRead = true;
            break;
        }
        return this.finishRead;
    }

    @Override
    public ByteBuffer getBuffer() {
        if (this.position == 0) {
            return this.bufferList.get(this.position);
        }
        byte[] data = new byte[this.position * this.bufferList.get(0).capacity() + this.bufferList.get(this.position).limit()];
        int index = 0;
        for (int i = 0; i <= this.position; ++i) {
            ByteBuffer b = this.bufferList.get(i);
            System.arraycopy(b.array(), b.position(), data, index, b.remaining());
            index += b.remaining();
        }
        return ByteBuffer.wrap(data);
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(byte[] endFLag) {
        if (endFLag != null) {
            this.endFLag = endFLag;
        }
        this.finishRead = false;
        this.exceptIndex = 0;
        this.position = 0;
        this.bufferList.get(this.position).clear();
    }
}

