/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.timer;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import org.smartboot.socket.timer.Timer;
import org.smartboot.socket.timer.TimerTask;

public class HashedWheelTimer
implements Timer,
Runnable {
    private final long tickDuration;
    private final HashedWheelBucket[] wheel;
    private final int mask;
    private final Queue<HashedWheelTimerTask> newTimeouts = new ConcurrentLinkedQueue<HashedWheelTimerTask>();
    private final Queue<HashedWheelTimerTask> cancelledTimeouts = new ConcurrentLinkedQueue<HashedWheelTimerTask>();
    private final AtomicLong pendingTimeouts = new AtomicLong(0L);
    private volatile long startTime;
    private boolean running = true;
    public static final HashedWheelTimer DEFAULT_TIMER = new HashedWheelTimer(r -> {
        Thread thread = new Thread(r, "defaultHashedWheelTimer");
        thread.setDaemon(true);
        return thread;
    });
    private long tick;

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, int ticksPerWheel) {
        this.wheel = HashedWheelTimer.createWheel(ticksPerWheel);
        this.mask = this.wheel.length - 1;
        this.tickDuration = tickDuration;
        Thread workerThread = threadFactory.newThread(this);
        workerThread.start();
    }

    private static HashedWheelBucket[] createWheel(int ticksPerWheel) {
        ticksPerWheel = HashedWheelTimer.normalizeTicksPerWheel(ticksPerWheel);
        HashedWheelBucket[] wheel = new HashedWheelBucket[ticksPerWheel];
        for (int i = 0; i < wheel.length; ++i) {
            wheel[i] = new HashedWheelBucket();
        }
        return wheel;
    }

    private static int normalizeTicksPerWheel(int ticksPerWheel) {
        int n = ticksPerWheel - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public TimerTask scheduleWithFixedDelay(Runnable runnable, long delay, TimeUnit unit) {
        long deadline = System.currentTimeMillis() + unit.toMillis(delay);
        if (deadline <= 0L) {
            throw new IllegalArgumentException();
        }
        HashedWheelTimerTask timeout = new HashedWheelTimerTask(this, runnable, deadline);
        timeout.runnable = () -> {
            try {
                runnable.run();
            }
            finally {
                if (!timeout.isCancelled()) {
                    timeout.deadline = System.currentTimeMillis() + unit.toMillis(delay);
                    timeout.bucket = null;
                    timeout.next = null;
                    timeout.prev = null;
                    timeout.state = 0;
                    this.pendingTimeouts.incrementAndGet();
                    this.newTimeouts.add(timeout);
                }
            }
        };
        this.pendingTimeouts.incrementAndGet();
        this.newTimeouts.add(timeout);
        return timeout;
    }

    @Override
    public TimerTask schedule(Runnable runnable, long delay, TimeUnit unit) {
        long deadline = System.currentTimeMillis() + unit.toMillis(delay);
        if (deadline <= 0L) {
            throw new IllegalArgumentException();
        }
        HashedWheelTimerTask timeout = new HashedWheelTimerTask(this, runnable, deadline);
        this.pendingTimeouts.incrementAndGet();
        this.newTimeouts.add(timeout);
        return timeout;
    }

    public long pendingTimeouts() {
        return this.pendingTimeouts.get();
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        while (this.running) {
            long deadline = this.waitForNextTick();
            this.processCancelledTasks();
            this.transferTimeoutsToBuckets();
            this.wheel[(int)(this.tick & (long)this.mask)].execute(deadline, this.tickDuration);
            ++this.tick;
        }
    }

    private void transferTimeoutsToBuckets() {
        HashedWheelTimerTask timeout;
        for (int i = 0; i < 100000 && (timeout = this.newTimeouts.poll()) != null; ++i) {
            if (timeout.state() == 1) continue;
            long calculated = (timeout.deadline - this.startTime) / this.tickDuration;
            long ticks = Math.max(calculated, this.tick);
            int stopIndex = (int)(ticks & (long)this.mask);
            HashedWheelBucket bucket = this.wheel[stopIndex];
            bucket.addTimeout(timeout);
        }
    }

    private void processCancelledTasks() {
        HashedWheelTimerTask timeout;
        while ((timeout = this.cancelledTimeouts.poll()) != null) {
            timeout.remove();
        }
    }

    private long waitForNextTick() {
        long deadline = this.startTime + this.tickDuration * (this.tick + 1L);
        long currentTime;
        while (deadline > (currentTime = System.currentTimeMillis())) {
            try {
                Thread.sleep(deadline - currentTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return currentTime;
    }

    private static final class HashedWheelBucket {
        private HashedWheelTimerTask head;
        private HashedWheelTimerTask tail;

        private HashedWheelBucket() {
        }

        public void addTimeout(HashedWheelTimerTask timeout) {
            assert (timeout.bucket == null);
            timeout.bucket = this;
            if (this.head == null) {
                this.head = this.tail = timeout;
            } else {
                this.tail.next = timeout;
                timeout.prev = this.tail;
                this.tail = timeout;
            }
        }

        public void execute(long deadline, long tickDuration) {
            HashedWheelTimerTask timeout = this.head;
            while (timeout != null) {
                HashedWheelTimerTask next = timeout.next;
                if (timeout.deadline <= deadline || timeout.deadline < System.currentTimeMillis() + tickDuration) {
                    next = this.remove(timeout);
                    timeout.execute();
                } else if (timeout.isCancelled()) {
                    next = this.remove(timeout);
                }
                timeout = next;
            }
        }

        public HashedWheelTimerTask remove(HashedWheelTimerTask timeout) {
            HashedWheelTimerTask next = timeout.next;
            if (timeout.prev != null) {
                timeout.prev.next = next;
            }
            if (timeout.next != null) {
                timeout.next.prev = timeout.prev;
            }
            if (timeout == this.head) {
                if (timeout == this.tail) {
                    this.tail = null;
                    this.head = null;
                } else {
                    this.head = next;
                }
            } else if (timeout == this.tail) {
                this.tail = timeout.prev;
            }
            timeout.prev = null;
            timeout.next = null;
            timeout.bucket = null;
            timeout.timer.pendingTimeouts.decrementAndGet();
            return next;
        }
    }

    private static final class HashedWheelTimerTask
    implements TimerTask {
        private static final int ST_INIT = 0;
        private static final int ST_CANCELLED = 1;
        private static final int ST_EXPIRED = 2;
        private static final AtomicIntegerFieldUpdater<HashedWheelTimerTask> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimerTask.class, "state");
        private final HashedWheelTimer timer;
        private Runnable runnable;
        private long deadline;
        private volatile int state = 0;
        private HashedWheelTimerTask next;
        private HashedWheelTimerTask prev;
        private HashedWheelBucket bucket;

        HashedWheelTimerTask(HashedWheelTimer timer, Runnable runnable, long deadline) {
            this.timer = timer;
            this.runnable = runnable;
            this.deadline = deadline;
        }

        @Override
        public void cancel() {
            this.state = 1;
            this.timer.cancelledTimeouts.add(this);
        }

        void remove() {
            HashedWheelBucket bucket = this.bucket;
            if (bucket != null) {
                bucket.remove(this);
            } else {
                this.timer.pendingTimeouts.decrementAndGet();
            }
        }

        public boolean compareAndSetState(int expected, int state) {
            return STATE_UPDATER.compareAndSet(this, expected, state);
        }

        public int state() {
            return this.state;
        }

        @Override
        public boolean isCancelled() {
            return this.state() == 1;
        }

        @Override
        public boolean isDone() {
            return this.state() == 2;
        }

        public void execute() {
            if (!this.compareAndSetState(0, 2)) {
                return;
            }
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public String toString() {
            long currentTime = System.nanoTime();
            long remaining = this.deadline - currentTime + this.timer.startTime;
            StringBuilder buf = new StringBuilder(192).append(this.getClass().getSimpleName()).append('(').append("deadline: ");
            if (remaining > 0L) {
                buf.append(remaining).append(" ns later");
            } else if (remaining < 0L) {
                buf.append(-remaining).append(" ns ago");
            } else {
                buf.append("now");
            }
            if (this.isCancelled()) {
                buf.append(", cancelled");
            }
            return buf.append(", task: ").append(this.runnable).append(')').toString();
        }
    }
}

