/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.extensions;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.spi.ContentContext;
import io.github.swagger2markup.utils.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentExtension {
    private static final Logger logger = LoggerFactory.getLogger(ContentExtension.class);
    protected final Swagger2MarkupConverter.Context globalContext;
    protected final ContentContext contentContext;

    ContentExtension(Swagger2MarkupConverter.Context globalContext, ContentContext contentContext) {
        this.globalContext = globalContext;
        this.contentContext = contentContext;
    }

    protected void importContent(Path contentPath, Consumer<Reader> contentConsumer) {
        block18: {
            if (Files.isReadable(contentPath)) {
                try (BufferedReader contentReader = Files.newBufferedReader(contentPath, StandardCharsets.UTF_8);){
                    contentConsumer.accept(contentReader);
                    if (logger.isInfoEnabled()) {
                        logger.info("Content file {} imported", (Object)contentPath);
                    }
                    break block18;
                }
                catch (IOException e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Failed to read content file {} > {}", (Object)contentPath, (Object)e.getMessage());
                    }
                    break block18;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to read content file {}", (Object)contentPath);
            }
        }
    }

    protected void importContent(URI contentUri, Consumer<Reader> contentConsumer) {
        block15: {
            try (Reader contentReader = IOUtils.uriReader((URI)contentUri);){
                contentConsumer.accept(contentReader);
                if (logger.isInfoEnabled()) {
                    logger.info("Content URI {} processed", (Object)contentUri);
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block15;
                logger.debug("Failed to read content URI {} > {}", (Object)contentUri, (Object)e.getMessage());
            }
        }
    }
}

