/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.extensions;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.extensions.ContentExtension;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.spi.ContentContext;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicContentExtension
extends ContentExtension {
    private static final Logger logger = LoggerFactory.getLogger(DynamicContentExtension.class);

    DynamicContentExtension(Swagger2MarkupConverter.Context globalContext, ContentContext contentContext) {
        super(globalContext, contentContext);
    }

    public void extensionsSection(MarkupLanguage extensionMarkupLanguage, Path contentPath, String prefix, int levelOffset) {
        block16: {
            Collection filenameExtensions = this.globalContext.getConfig().getMarkupLanguage().getFileNameExtensions().stream().map(fileExtension -> StringUtils.stripStart((String)fileExtension, (String)".")).collect(Collectors.toList());
            DirectoryStream.Filter<Path> filter = entry -> {
                String fileName = entry.getFileName().toString();
                return fileName.startsWith(prefix) && FilenameUtils.isExtension((String)fileName, (Collection)filenameExtensions);
            };
            try (DirectoryStream<Path> extensionFiles = Files.newDirectoryStream(contentPath, filter);){
                if (extensionFiles != null) {
                    ArrayList extensions = Lists.newArrayList(extensionFiles);
                    Collections.sort(extensions, Ordering.natural());
                    for (Path extension : extensions) {
                        this.importContent(extension, (Reader reader) -> this.contentContext.getMarkupDocBuilder().importMarkup(reader, extensionMarkupLanguage, levelOffset));
                    }
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block16;
                logger.debug("Failed to read extension files from directory {}", (Object)contentPath);
            }
        }
    }
}

