/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.ObjectProvider;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.util.Map;
import sun.misc.Unsafe;

public abstract class GetLoadedPackagesFunction
implements Function<ClassLoader, Map<String, ?>> {

    public static abstract class Native
    extends GetLoadedPackagesFunction {

        public static class ForJava7
        extends Native {
            Field packagesField;

            public ForJava7(Map<Object, Object> context) {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.packagesField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "packages");
            }

            @Override
            public Map<String, ?> apply(ClassLoader classLoader) {
                return (Map)Narcissus.getField((Object)classLoader, (Field)this.packagesField);
            }
        }
    }

    public static class ForJava7
    extends GetLoadedPackagesFunction {
        final Unsafe unsafe;
        final Long fieldOffset;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
            this.fieldOffset = this.unsafe.objectFieldOffset((Field)getDeclaredFieldFunction.apply(ClassLoader.class, "packages"));
        }

        @Override
        public Map<String, ?> apply(ClassLoader classLoader) {
            return (Map)this.unsafe.getObject(classLoader, this.fieldOffset);
        }
    }
}

