/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.narcissus;

import io.github.toolfactory.narcissus.Narcissus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

class LibraryLoader {
    public static final OperatingSystem OS;
    public static int archBits;

    LibraryLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadLibraryFromJar(String libraryResourcePath) {
        File tempFile = null;
        boolean tempFileIsPosix = false;
        InputStream inputSream = null;
        try {
            inputSream = Narcissus.class.getResourceAsStream(libraryResourcePath.startsWith("/") ? libraryResourcePath : "/" + libraryResourcePath);
            if (inputSream == null) {
                throw new FileNotFoundException("Could not find library within jar: " + libraryResourcePath);
            }
            String filename = libraryResourcePath.substring(libraryResourcePath.lastIndexOf(47) + 1);
            int dotIdx = filename.indexOf(46);
            String baseName = dotIdx < 0 ? filename : filename.substring(0, dotIdx);
            String suffix = dotIdx < 0 ? ".so" : filename.substring(dotIdx);
            tempFile = File.createTempFile(baseName + "_", suffix);
            try {
                if (tempFile.toPath().getFileSystem().supportedFileAttributeViews().contains("posix")) {
                    tempFileIsPosix = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] buffer = new byte[8192];
            try (FileOutputStream os = new FileOutputStream(tempFile);){
                int readBytes;
                while ((readBytes = inputSream.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, readBytes);
                }
            }
            System.load(tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load library " + libraryResourcePath + " : " + e);
        }
        finally {
            if (inputSream != null) {
                try {
                    inputSream.close();
                }
                catch (IOException iOException) {}
            }
            if (tempFile != null) {
                boolean deleted = false;
                if (tempFileIsPosix) {
                    deleted = tempFile.delete();
                }
                if (!deleted) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    static {
        String osName = null;
        try {
            osName = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        OS = osName == null ? OperatingSystem.Unknown : (osName.contains("mac") || osName.contains("darwin") ? OperatingSystem.MacOSX : (osName.contains("win") ? OperatingSystem.Windows : (osName.contains("nux") ? OperatingSystem.Linux : (osName.contains("sunos") || osName.contains("solaris") ? OperatingSystem.Solaris : (osName.contains("bsd") ? OperatingSystem.Unix : (osName.contains("nix") || osName.contains("aix") ? OperatingSystem.Unix : OperatingSystem.Unknown))))));
        archBits = 64;
        String dataModel = System.getProperty("sun.arch.data.model");
        if (dataModel != null && dataModel.contains("32")) {
            archBits = 32;
        } else {
            String osArch = System.getProperty("os.arch");
            if (osArch != null && (osArch.contains("86") && !osArch.contains("64") || osArch.contains("32"))) {
                archBits = 32;
            }
        }
    }

    static enum OperatingSystem {
        Windows,
        MacOSX,
        Linux,
        Solaris,
        BSD,
        Unix,
        Unknown;

    }
}

