/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs;

import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import io.github.yedaxia.apidocs.DocsConfig;
import io.github.yedaxia.apidocs.I18n;
import io.github.yedaxia.apidocs.IResponseWrapper;
import io.github.yedaxia.apidocs.LogUtils;
import io.github.yedaxia.apidocs.ParseUtils;
import io.github.yedaxia.apidocs.ProjectType;
import io.github.yedaxia.apidocs.Resources;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.exception.ConfigException;
import io.github.yedaxia.apidocs.parser.AbsControllerParser;
import io.github.yedaxia.apidocs.parser.GenericControllerParser;
import io.github.yedaxia.apidocs.parser.JFinalControllerParser;
import io.github.yedaxia.apidocs.parser.JFinalRoutesParser;
import io.github.yedaxia.apidocs.parser.PlayControllerParser;
import io.github.yedaxia.apidocs.parser.PlayRoutesParser;
import io.github.yedaxia.apidocs.parser.ResponseNode;
import io.github.yedaxia.apidocs.parser.SpringControllerParser;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DocContext {
    private static String projectPath;
    private static String docPath;
    private static List<String> javaSrcPaths;
    private static AbsControllerParser controllerParser;
    private static List<File> controllerFiles;
    private static IResponseWrapper responseWrapper;
    private static DocsConfig config;
    private static I18n i18n;
    private static String currentApiVersion;
    private static List<String> apiVersionList;

    public static void init(DocsConfig config) {
        if (config.projectPath == null || !new File(config.projectPath).exists()) {
            throw new ConfigException(String.format("projectDir doesn't exists. %s", projectPath));
        }
        if (config.getApiVersion() == null) {
            throw new ConfigException("api version cannot be null");
        }
        if (config.getProjectName() == null) {
            config.setProjectName("JApiDocs");
        }
        DocContext.config = config;
        i18n = new I18n(config.getLocale());
        currentApiVersion = config.getApiVersion();
        DocContext.setProjectPath(config.projectPath);
        DocContext.setDocPath(config);
        DocContext.initApiVersions();
        Resources.setUserCodeTplPath(config.codeTplPath);
        File logFile = DocContext.getLogFile();
        if (logFile.exists()) {
            logFile.delete();
        }
        if (config.getJavaSrcPaths().isEmpty()) {
            DocContext.findOutJavaSrcPaths();
        } else {
            javaSrcPaths.addAll(config.getJavaSrcPaths());
        }
        LogUtils.info("find java src paths:  %s", javaSrcPaths);
        ProjectType projectType = DocContext.findOutProjectType();
        DocContext.findOutControllers(projectType);
    }

    private static void findOutJavaSrcPaths() {
        File projectDir = new File(projectPath);
        List<String> moduleNames = Utils.getModuleNames(projectDir);
        if (moduleNames != null && !moduleNames.isEmpty()) {
            for (String moduleName : moduleNames) {
                String javaSrcPath = DocContext.findModuleSrcPath(new File(projectDir, moduleName));
                javaSrcPaths.add(javaSrcPath);
            }
        }
        if (javaSrcPaths.isEmpty()) {
            String javaSrcPath = DocContext.findModuleSrcPath(projectDir);
            javaSrcPaths.add(javaSrcPath);
        }
    }

    private static void initApiVersions() {
        File docDir = new File(docPath).getParentFile();
        String[] diffVersionApiDirs = docDir.list((dir, name) -> dir.isDirectory() && !name.startsWith("."));
        if (diffVersionApiDirs != null) {
            Collections.addAll(apiVersionList, diffVersionApiDirs);
        }
    }

    private static ProjectType findOutProjectType() {
        ProjectType projectType = null;
        if (config.isSpringMvcProject()) {
            projectType = ProjectType.SPRING;
        } else if (config.isJfinalProject()) {
            projectType = ProjectType.JFINAL;
        } else if (config.isPlayProject()) {
            projectType = ProjectType.PLAY;
        } else if (config.isGeneric()) {
            projectType = ProjectType.GENERIC;
        }
        if (projectType == null) {
            LogUtils.info("project type not set, try to figure out...", new Object[0]);
            for (String javaSrcPath : javaSrcPaths) {
                File javaSrcDir = new File(javaSrcPath);
                if (Utils.isSpringFramework(javaSrcDir)) {
                    projectType = ProjectType.SPRING;
                } else if (Utils.isPlayFramework(new File(DocContext.getProjectPath()))) {
                    projectType = ProjectType.PLAY;
                } else if (Utils.isJFinalFramework(javaSrcDir)) {
                    projectType = ProjectType.JFINAL;
                }
                if (projectType == null) continue;
                return projectType;
            }
        }
        projectType = projectType != null ? projectType : ProjectType.GENERIC;
        LogUtils.info("found it a %s project, tell us if we are wrong.", new Object[]{projectType});
        return projectType;
    }

    private static void findOutControllers(ProjectType projectType) {
        controllerFiles = new ArrayList<File>();
        for (String javaSrcPath : DocContext.getJavaSrcPaths()) {
            LogUtils.info("start find controllers in path : %s", javaSrcPath);
            File javaSrcDir = new File(javaSrcPath);
            ArrayList<File> result = new ArrayList<File>();
            switch (projectType) {
                case PLAY: {
                    controllerParser = new PlayControllerParser();
                    LinkedHashSet<String> controllerFileNames = new LinkedHashSet<String>();
                    List<PlayRoutesParser.RouteNode> routeNodeList = PlayRoutesParser.INSTANCE.getRouteNodeList();
                    for (PlayRoutesParser.RouteNode node : routeNodeList) {
                        controllerFileNames.add(node.controllerFile);
                    }
                    for (String controllerFileName : controllerFileNames) {
                        controllerFiles.add(new File(controllerFileName));
                    }
                    break;
                }
                case JFINAL: {
                    controllerParser = new JFinalControllerParser();
                    LinkedHashSet<String> controllerFileNames = new LinkedHashSet();
                    List<JFinalRoutesParser.RouteNode> jFinalRouteNodeList = JFinalRoutesParser.INSTANCE.getRouteNodeList();
                    for (JFinalRoutesParser.RouteNode node : jFinalRouteNodeList) {
                        controllerFileNames.add(node.controllerFile);
                    }
                    for (String controllerFileName : controllerFileNames) {
                        controllerFiles.add(new File(controllerFileName));
                    }
                    break;
                }
                case SPRING: {
                    controllerParser = new SpringControllerParser();
                    Utils.wideSearchFile(javaSrcDir, new FilenameFilter(){

                        @Override
                        public boolean accept(File f, String name) {
                            return f.getName().endsWith(".java") && ParseUtils.compilationUnit(f).getChildNodesByType(ClassOrInterfaceDeclaration.class).stream().anyMatch(cd -> cd.getAnnotationByName("Controller").isPresent() || cd.getAnnotationByName("RestController").isPresent());
                        }
                    }, result, false);
                    controllerFiles.addAll(result);
                    break;
                }
                default: {
                    controllerParser = new GenericControllerParser();
                    Utils.wideSearchFile(javaSrcDir, new FilenameFilter(){

                        @Override
                        public boolean accept(File f, String name) {
                            return f.getName().endsWith(".java") && ParseUtils.compilationUnit(f).getChildNodesByType(ClassOrInterfaceDeclaration.class).stream().anyMatch(cd -> cd.getChildNodesByType(MethodDeclaration.class).stream().anyMatch(md -> md.getAnnotationByName("ApiDoc").isPresent()));
                        }
                    }, result, false);
                    controllerFiles.addAll(result);
                }
            }
            for (File controllerFile : result) {
                LogUtils.info("find controller file : %s", controllerFile.getName());
            }
        }
    }

    private static String findModuleSrcPath(final File moduleDir) {
        ArrayList<File> result = new ArrayList<File>();
        Utils.wideSearchFile(moduleDir, new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                if (name.endsWith(".java")) {
                    Optional opPackageDeclaration = ParseUtils.compilationUnit(file).getPackageDeclaration();
                    if (opPackageDeclaration.isPresent()) {
                        String packageName = ((PackageDeclaration)opPackageDeclaration.get()).getNameAsString();
                        return !Utils.hasDirInFile(file, moduleDir, "test") || packageName.contains("test");
                    }
                    return !Utils.hasDirInFile(file, moduleDir, "test");
                }
                return false;
            }
        }, result, true);
        if (result.isEmpty()) {
            throw new RuntimeException("cannot find any java file in this module : " + moduleDir.getName());
        }
        File oneJavaFile = (File)result.get(0);
        Optional opPackageDeclaration = ParseUtils.compilationUnit(oneJavaFile).getPackageDeclaration();
        String parentPath = oneJavaFile.getParentFile().getAbsolutePath();
        if (opPackageDeclaration.isPresent()) {
            return parentPath.substring(0, parentPath.length() - ((PackageDeclaration)opPackageDeclaration.get()).getNameAsString().length());
        }
        return parentPath + "/";
    }

    public static File getLogFile() {
        return new File(DocContext.getDocPath(), "apidoc.log");
    }

    public static String getProjectPath() {
        return projectPath;
    }

    private static void setProjectPath(String projectPath) {
        if (projectPath != null) {
            DocContext.projectPath = new File(projectPath).getAbsolutePath() + "/";
        }
    }

    public static String getDocPath() {
        return docPath;
    }

    private static void setDocPath(DocsConfig config) {
        File docDir;
        if (config.docsPath == null || config.docsPath.isEmpty()) {
            config.docsPath = projectPath + "apidocs";
        }
        if (!(docDir = new File(config.docsPath, config.apiVersion)).exists()) {
            docDir.mkdirs();
        }
        docPath = docDir.getAbsolutePath();
    }

    public static List<String> getJavaSrcPaths() {
        return javaSrcPaths;
    }

    public static File[] getControllerFiles() {
        return controllerFiles.toArray(new File[controllerFiles.size()]);
    }

    public static AbsControllerParser controllerParser() {
        return controllerParser;
    }

    public static IResponseWrapper getResponseWrapper() {
        if (responseWrapper == null) {
            responseWrapper = new IResponseWrapper(){

                @Override
                public Map<String, Object> wrapResponse(ResponseNode responseNode) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("code", 0);
                    resultMap.put("data", responseNode);
                    resultMap.put("msg", "success");
                    return resultMap;
                }
            };
        }
        return responseWrapper;
    }

    public static DocsConfig getDocsConfig() {
        return config;
    }

    public static String getCurrentApiVersion() {
        return currentApiVersion;
    }

    public static List<String> getApiVersionList() {
        return apiVersionList;
    }

    public static I18n getI18n() {
        return i18n;
    }

    static void setResponseWrapper(IResponseWrapper responseWrapper) {
        DocContext.responseWrapper = responseWrapper;
    }

    static {
        javaSrcPaths = new ArrayList<String>();
        apiVersionList = new ArrayList<String>();
    }
}

