/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.doc;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.Resources;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.codegenerator.ios.ModelCodeGenerator;
import io.github.yedaxia.apidocs.codegenerator.java.JavaCodeGenerator;
import io.github.yedaxia.apidocs.doc.IControllerDocBuilder;
import io.github.yedaxia.apidocs.parser.ControllerNode;
import io.github.yedaxia.apidocs.parser.RequestNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class HtmlControllerDocBuilder
implements IControllerDocBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String buildDoc(ControllerNode controllerNode) throws IOException {
        for (RequestNode requestNode : controllerNode.getRequestNodes()) {
            if (requestNode.getResponseNode() == null || requestNode.getResponseNode().getChildNodes().isEmpty()) continue;
            JavaCodeGenerator javaCodeGenerator = new JavaCodeGenerator(requestNode.getResponseNode());
            String javaSrcUrl = javaCodeGenerator.generateCode();
            requestNode.setAndroidCodePath(javaSrcUrl);
            ModelCodeGenerator iosCodeGenerator = new ModelCodeGenerator(requestNode.getResponseNode());
            String iosSrcUrl = iosCodeGenerator.generateCode();
            requestNode.setIosCodePath(iosSrcUrl);
        }
        Template ctrlTemplate = this.getControllerTpl();
        File docFile = new File(DocContext.getDocPath(), controllerNode.getDocFileName());
        FileWriter docFileWriter = new FileWriter(docFile);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("controller", controllerNode);
        data.put("currentApiVersion", DocContext.getCurrentApiVersion());
        data.put("apiVersionList", DocContext.getApiVersionList());
        data.put("projectName", DocContext.getDocsConfig().getProjectName());
        data.put("i18n", DocContext.getI18n());
        try {
            ctrlTemplate.process(data, (Writer)docFileWriter);
        }
        catch (TemplateException ex) {
            ex.printStackTrace();
        }
        finally {
            Utils.closeSilently(docFileWriter);
        }
        return Utils.streamToString(new FileInputStream(docFile));
    }

    private Template getControllerTpl() throws IOException {
        return Resources.getFreemarkerTemplate("api-controller.html.ftl");
    }
}

