/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.parser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.ParseUtils;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.parser.ControllerNode;
import io.github.yedaxia.apidocs.parser.ParamNode;
import io.github.yedaxia.apidocs.parser.RequestNode;
import io.github.yedaxia.apidocs.parser.ResponseNode;
import java.io.File;
import java.util.List;

public abstract class AbsControllerParser {
    private CompilationUnit compilationUnit;
    private ControllerNode controllerNode;
    private File javaFile;

    public ControllerNode parse(File javaFile) {
        this.javaFile = javaFile;
        this.compilationUnit = ParseUtils.compilationUnit(javaFile);
        this.controllerNode = new ControllerNode();
        String controllerName = Utils.getJavaFileName(javaFile);
        this.controllerNode.setClassName(controllerName);
        this.compilationUnit.getClassByName(controllerName).ifPresent(c -> {
            this.beforeHandleController(this.controllerNode, (ClassOrInterfaceDeclaration)c);
            this.parseClassDoc((ClassOrInterfaceDeclaration)c);
            this.parseMethodDocs((ClassOrInterfaceDeclaration)c);
            this.afterHandleController(this.controllerNode, (ClassOrInterfaceDeclaration)c);
        });
        return this.controllerNode;
    }

    File getControllerFile() {
        return this.javaFile;
    }

    ControllerNode getControllerNode() {
        return this.controllerNode;
    }

    private void parseClassDoc(ClassOrInterfaceDeclaration c) {
        ((Node)c.getParentNode().get()).findFirst(PackageDeclaration.class).ifPresent(pd -> this.controllerNode.setPackageName(pd.getNameAsString()));
        boolean generateDocs = c.getAnnotationByName("ApiDoc").isPresent();
        this.controllerNode.setGenerateDocs(generateDocs);
        c.getJavadoc().ifPresent(d -> {
            String description = d.getDescription().toText();
            this.controllerNode.setDescription(Utils.isNotEmpty(description) ? description : c.getNameAsString());
            List blockTags = d.getBlockTags();
            if (blockTags != null) {
                for (JavadocBlockTag blockTag : blockTags) {
                    if ("author".equalsIgnoreCase(blockTag.getTagName())) {
                        this.controllerNode.setAuthor(blockTag.getContent().toText());
                    }
                    if (!"description".equalsIgnoreCase(blockTag.getTagName())) continue;
                    this.controllerNode.setDescription(blockTag.getContent().toText());
                }
            }
        });
        if (this.controllerNode.getDescription() == null) {
            this.controllerNode.setDescription(c.getNameAsString());
        }
    }

    private void parseMethodDocs(ClassOrInterfaceDeclaration c) {
        c.findAll(MethodDeclaration.class).stream().filter(m -> m.getModifiers().contains(Modifier.PUBLIC)).forEach(m -> {
            boolean existsApiDoc = m.getAnnotationByName("ApiDoc").isPresent();
            if (!(existsApiDoc || this.controllerNode.getGenerateDocs().booleanValue() || DocContext.getDocsConfig().getAutoGenerate().booleanValue())) {
                return;
            }
            RequestNode requestNode = new RequestNode();
            requestNode.setControllerNode(this.controllerNode);
            requestNode.setMethodName(m.getNameAsString());
            m.getAnnotationByClass(Deprecated.class).ifPresent(f -> requestNode.setDeprecated(true));
            m.getJavadoc().ifPresent(d -> {
                String description = d.getDescription().toText();
                requestNode.setDescription(description);
                d.getBlockTags().stream().filter(t -> t.getTagName().equals("param")).forEach(t -> {
                    ParamNode paramNode = new ParamNode();
                    paramNode.setName((String)t.getName().get());
                    paramNode.setDescription(t.getContent().toText());
                    requestNode.addParamNode(paramNode);
                });
            });
            m.getParameters().forEach(p -> {
                String paraName = p.getName().asString();
                ParamNode paramNode = requestNode.getParamNodeByName(paraName);
                if (paramNode != null) {
                    paramNode.setType(ParseUtils.unifyType(p.getType().asString()));
                }
            });
            Type resultClassType = null;
            if (existsApiDoc) {
                AnnotationExpr an = (AnnotationExpr)m.getAnnotationByName("ApiDoc").get();
                if (an instanceof SingleMemberAnnotationExpr) {
                    resultClassType = ((ClassExpr)((SingleMemberAnnotationExpr)an).getMemberValue()).getType();
                } else if (an instanceof NormalAnnotationExpr) {
                    for (MemberValuePair pair : ((NormalAnnotationExpr)an).getPairs()) {
                        String pairName = pair.getNameAsString();
                        if ("result".equals(pairName) || "value".equals(pairName)) {
                            resultClassType = ((ClassExpr)pair.getValue()).getType();
                            continue;
                        }
                        if (pairName.equals("url")) {
                            requestNode.setUrl(((StringLiteralExpr)pair.getValue()).getValue());
                            continue;
                        }
                        if (!pairName.equals("method")) continue;
                        requestNode.addMethod(((StringLiteralExpr)pair.getValue()).getValue());
                    }
                }
            }
            this.afterHandleMethod(requestNode, (MethodDeclaration)m);
            if (resultClassType == null) {
                if (m.getType() == null) {
                    return;
                }
                resultClassType = m.getType();
            }
            ResponseNode responseNode = new ResponseNode();
            responseNode.setRequestNode(requestNode);
            ParseUtils.parseClassNodeByType(this.javaFile, responseNode, resultClassType.getElementType());
            requestNode.setResponseNode(responseNode);
            this.controllerNode.addRequestNode(requestNode);
        });
    }

    protected void beforeHandleController(ControllerNode controllerNode, ClassOrInterfaceDeclaration clazz) {
    }

    protected void afterHandleController(ControllerNode controllerNode, ClassOrInterfaceDeclaration clazz) {
    }

    protected void afterHandleMethod(RequestNode requestNode, MethodDeclaration md) {
    }
}

