/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.LogUtils;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.exception.JavaFileNotFoundException;
import io.github.yedaxia.apidocs.parser.ClassNode;
import io.github.yedaxia.apidocs.parser.FieldNode;
import io.github.yedaxia.apidocs.parser.GenericNode;
import io.github.yedaxia.apidocs.parser.MockNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ParseUtils {
    private static final String TYPE_MODEL = "unkown";
    private static final Set<String> classNodeSet = new HashSet<String>();

    public static File searchJavaFile(File inJavaFile, String className) {
        String javaSrcPath;
        File file = null;
        Iterator<String> iterator = DocContext.getJavaSrcPaths().iterator();
        while (iterator.hasNext() && (file = ParseUtils.searchJavaFileInner(javaSrcPath = iterator.next(), inJavaFile, className)) == null) {
        }
        if (file == null) {
            throw new JavaFileNotFoundException("Cannot find java file , in java file : " + inJavaFile.getAbsolutePath() + ", className : " + className);
        }
        return file;
    }

    private static File searchJavaFileInner(String javaSrcPath, File inJavaFile, final String className) {
        File javaFile;
        block8: {
            String packageName;
            ImportDeclaration importDeclaration;
            CompilationUnit compilationUnit = ParseUtils.compilationUnit(inJavaFile);
            Optional<ImportDeclaration> idOp = compilationUnit.getImports().stream().filter(im -> im.getNameAsString().endsWith("." + className)).findFirst();
            if (idOp.isPresent()) {
                String[] cPaths = idOp.get().getNameAsString().split("\\.");
                return ParseUtils.backTraceJavaFileByName(javaSrcPath, cPaths);
            }
            if (ParseUtils.getInnerClassNode(compilationUnit, className).isPresent()) {
                return inJavaFile;
            }
            String[] cPaths = className.split("\\.");
            if (cPaths.length == 1) {
                File[] javaFiles = inJavaFile.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(className + ".java");
                    }
                });
                if (javaFiles != null && javaFiles.length == 1) {
                    return javaFiles[0];
                }
            } else {
                File javaFile2;
                final String firstPath = cPaths[0];
                File[] javaFiles = inJavaFile.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        int i = name.lastIndexOf(".java");
                        if (i == -1) {
                            return false;
                        }
                        return name.substring(0, i).equals(firstPath);
                    }
                });
                if (javaFiles != null && javaFiles.length > 0 && ParseUtils.getInnerClassNode(ParseUtils.compilationUnit(javaFile2 = javaFiles[0]), className).isPresent()) {
                    return javaFile2;
                }
            }
            if ((javaFile = ParseUtils.backTraceJavaFileByName(javaSrcPath, cPaths)) != null) {
                return javaFile;
            }
            NodeList importDeclarations = compilationUnit.getImports();
            if (!importDeclarations.isNonEmpty()) break block8;
            Iterator iterator = importDeclarations.iterator();
            while (iterator.hasNext() && (!(importDeclaration = (ImportDeclaration)iterator.next()).toString().contains(".*") || (javaFile = ParseUtils.backTraceJavaFileByName(javaSrcPath, cPaths = ((packageName = importDeclaration.getNameAsString()) + "." + className).split("\\."))) == null)) {
            }
        }
        return javaFile;
    }

    private static Optional<TypeDeclaration> getInnerClassNode(CompilationUnit compilationUnit, String className) {
        return compilationUnit.findAll(TypeDeclaration.class).stream().filter(c -> c instanceof ClassOrInterfaceDeclaration || c instanceof EnumDeclaration).filter(c -> className.equals(c.getNameAsString())).findFirst();
    }

    private static File backTraceJavaFileByName(String javaSrcPath, String[] cPaths) {
        if (cPaths.length == 0) {
            return null;
        }
        String javaFilePath = javaSrcPath + Utils.joinArrayString(cPaths, "/") + ".java";
        File javaFile = new File(javaFilePath);
        if (javaFile.exists() && javaFile.isFile()) {
            return javaFile;
        }
        return ParseUtils.backTraceJavaFileByName(javaSrcPath, Arrays.copyOf(cPaths, cPaths.length - 1));
    }

    public static CompilationUnit compilationUnit(File javaFile) {
        try {
            return JavaParser.parse((File)javaFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("java file not exits , file path : " + javaFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("parser error , file path : " + javaFile.getAbsolutePath());
        }
    }

    public static void parseClassNodeByType(File inJavaFile, ClassNode rootClassNode, Type classType) {
        if (classType.getParentNode().get() instanceof ArrayType) {
            rootClassNode.setList(true);
        } else if (classType instanceof ArrayType) {
            rootClassNode.setList(true);
            classType = ((ArrayType)classType).getComponentType();
        } else if (ParseUtils.isCollectionType(classType.asString())) {
            rootClassNode.setList(true);
            List collectionType = classType.getChildNodesByType(ClassOrInterfaceType.class);
            if (collectionType.isEmpty()) {
                LogUtils.warn("We found Collection without specified Class Type, Please check ! java file : %s", inJavaFile.getName());
                rootClassNode.setClassName("Object");
                return;
            }
            classType = (Type)collectionType.get(0);
        }
        String unifyClassType = ParseUtils.unifyType(classType.asString());
        if (TYPE_MODEL.equals(unifyClassType)) {
            if (classType instanceof ClassOrInterfaceType) {
                ((ClassOrInterfaceType)classType).getTypeArguments().ifPresent(typeList -> typeList.forEach(argType -> {
                    GenericNode rootGenericNode = new GenericNode();
                    rootGenericNode.setFromJavaFile(inJavaFile);
                    rootGenericNode.setClassType((Type)argType);
                    rootClassNode.addGenericNode(rootGenericNode);
                }));
                String className = ((ClassOrInterfaceType)classType).getName().getIdentifier();
                rootClassNode.setClassName(className);
                File modelJavaFile = ParseUtils.searchJavaFile(inJavaFile, className);
                rootClassNode.setClassFileName(modelJavaFile.getAbsolutePath());
                ParseUtils.parseClassNode(modelJavaFile, rootClassNode);
            }
        } else {
            rootClassNode.setClassName(unifyClassType);
        }
    }

    public static void parseClassNode(File modelJavaFile, ClassNode classNode) {
        ParseUtils.innerParseClassNode(modelJavaFile, classNode);
    }

    private static void innerParseClassNode(File modelJavaFile, ClassNode classNode) {
        String resultClassName = classNode.getClassName();
        ParseUtils.compilationUnit(modelJavaFile).findAll(ClassOrInterfaceDeclaration.class).stream().filter(f -> resultClassName.endsWith(f.getNameAsString())).findFirst().ifPresent(cl -> {
            NodeList exClassTypeList;
            NodeList typeParameters = cl.getTypeParameters();
            if (typeParameters.isNonEmpty() && classNode.getGenericNodes().size() == typeParameters.size()) {
                int len = typeParameters.size();
                for (int i = 0; i != len; ++i) {
                    classNode.getGenericNode(i).setPlaceholder(((TypeParameter)typeParameters.get(i)).getName().getIdentifier());
                }
            }
            if (!(exClassTypeList = cl.getExtendedTypes()).isEmpty()) {
                String extendClassName = ((ClassOrInterfaceType)exClassTypeList.get(0)).getNameAsString();
                classNode.setClassName(extendClassName);
                ParseUtils.innerParseClassNode(ParseUtils.searchJavaFile(modelJavaFile, extendClassName), classNode);
            }
            cl.findAll(FieldDeclaration.class).stream().filter(fd -> !fd.getModifiers().contains(Modifier.STATIC)).forEach(fd -> {
                ClassOrInterfaceDeclaration cClDeclaration = (ClassOrInterfaceDeclaration)fd.getParentNode().get();
                if (!resultClassName.equals(cClDeclaration.getNameAsString())) {
                    return;
                }
                if (fd.getAnnotationByName("Ignore").isPresent()) {
                    return;
                }
                boolean notNull = ParseUtils.isFieldNotNull(fd);
                fd.getVariables().forEach(field -> {
                    FieldNode fieldNode = new FieldNode();
                    fieldNode.setNotNull(notNull);
                    fieldNode.setClassNode(classNode);
                    classNode.addChildNode(fieldNode);
                    fd.getComment().ifPresent(c -> fieldNode.setDescription(Utils.cleanCommentContent(c.getContent())));
                    if (!Utils.isNotEmpty(fieldNode.getDescription())) {
                        field.getComment().ifPresent(c -> fieldNode.setDescription(Utils.cleanCommentContent(c.getContent())));
                    }
                    fd.getAnnotationByName("RapMock").ifPresent(an -> {
                        if (an instanceof NormalAnnotationExpr) {
                            NormalAnnotationExpr normalAnExpr = (NormalAnnotationExpr)an;
                            MockNode mockNode = new MockNode();
                            for (MemberValuePair mvPair : normalAnExpr.getPairs()) {
                                String name = mvPair.getName().asString();
                                if ("limit".equalsIgnoreCase(name)) {
                                    mockNode.setLimit(Utils.removeQuotations(mvPair.getValue().toString()));
                                    continue;
                                }
                                if (!"value".equalsIgnoreCase(name)) continue;
                                mockNode.setValue(Utils.removeQuotations(mvPair.getValue().toString()));
                            }
                            fieldNode.setMockNode(mockNode);
                        } else if (an instanceof SingleMemberAnnotationExpr) {
                            SingleMemberAnnotationExpr singleAnExpr = (SingleMemberAnnotationExpr)an;
                            MockNode mockNode = new MockNode();
                            mockNode.setValue(Utils.removeQuotations(singleAnExpr.getMemberValue().toString()));
                            fieldNode.setMockNode(mockNode);
                        }
                    });
                    fieldNode.setName(field.getNameAsString());
                    Type fieldType = fd.getElementType();
                    ParseUtils.parseFieldNode(fieldNode, modelJavaFile, fieldType);
                });
            });
        });
        classNode.setClassName(resultClassName);
    }

    private static boolean isFieldNotNull(FieldDeclaration fd) {
        return fd.getAnnotationByName("NotNull").isPresent() || fd.getAnnotationByName("NotBlank").isPresent() || fd.getAnnotationByName("NotEmpty").isPresent();
    }

    private static void parseFieldNode(FieldNode fieldNode, File inJavaFile, Type fieldType) {
        block21: {
            Boolean isList;
            String fieldClassType;
            GenericNode genericNode = fieldNode.getClassNode().getGenericNode(fieldType.asString());
            if (genericNode == null && !fieldType.asString().contains("<") && TYPE_MODEL.equals(ParseUtils.unifyType(fieldClassType = fieldType.asString()))) {
                Optional<EnumDeclaration> ed = null;
                try {
                    File childJavaFile = ParseUtils.searchJavaFile(inJavaFile, fieldClassType);
                    ed = ParseUtils.compilationUnit(childJavaFile).getChildNodesByType(EnumDeclaration.class).stream().filter(em -> fieldClassType.endsWith(em.getNameAsString())).findFirst();
                }
                catch (JavaFileNotFoundException ex) {
                    LogUtils.info("we think %s should not be an enum type", fieldClassType);
                }
                if (ed != null && ed.isPresent()) {
                    fieldNode.setType("string");
                    List constants = ed.get().getChildNodesByType(EnumConstantDeclaration.class);
                    StringBuilder sb = new StringBuilder(fieldNode.getDescription() == null ? "" : fieldNode.getDescription());
                    sb.append(" [");
                    int size = constants.size();
                    for (int i = 0; i != size; ++i) {
                        sb.append(((EnumConstantDeclaration)constants.get(i)).getNameAsString());
                        if (i == size - 1) continue;
                        sb.append(",");
                    }
                    sb.append("]");
                    fieldNode.setDescription(sb.toString());
                    return;
                }
            }
            if (genericNode != null) {
                fieldType = genericNode.getClassType();
                inJavaFile = genericNode.getFromJavaFile();
            }
            if (fieldType.getParentNode().get() instanceof ArrayType) {
                isList = true;
            } else if (fieldType instanceof ArrayType) {
                isList = true;
                fieldType = ((ArrayType)fieldType).getComponentType();
                GenericNode arrayTypeNode = fieldNode.getClassNode().getGenericNode(fieldType.asString());
                if (arrayTypeNode != null) {
                    fieldType = arrayTypeNode.getClassType();
                    inJavaFile = arrayTypeNode.getFromJavaFile();
                }
            } else if (ParseUtils.isCollectionType(fieldType.asString())) {
                isList = true;
                List collectionType = fieldType.getChildNodesByType(ClassOrInterfaceType.class);
                if (collectionType.isEmpty()) {
                    LogUtils.warn("We found Collection without specified Class Type, Please check ! java file : %s", inJavaFile.getName());
                    fieldNode.setType("Object[]");
                    return;
                }
                GenericNode collectionGenericNode = fieldNode.getClassNode().getGenericNode(((ClassOrInterfaceType)collectionType.get(0)).asString());
                if (collectionGenericNode != null) {
                    fieldType = collectionGenericNode.getClassType();
                    inJavaFile = collectionGenericNode.getFromJavaFile();
                } else {
                    fieldType = (Type)collectionType.get(0);
                }
            } else {
                isList = false;
            }
            String fieldClassType2 = fieldType instanceof ClassOrInterfaceType ? ((ClassOrInterfaceType)fieldType).getName().getIdentifier() : fieldType.asString();
            String unifyType = ParseUtils.unifyType(fieldClassType2);
            if (TYPE_MODEL.equals(unifyType)) {
                ClassNode childNode = new ClassNode();
                childNode.setParentNode(fieldNode.getClassNode());
                childNode.setList(isList);
                childNode.setClassName(fieldClassType2);
                fieldNode.setChildNode(childNode);
                fieldNode.setType(isList != false ? fieldClassType2 + "[]" : fieldClassType2);
                File childJavaFile = inJavaFile;
                ((ClassOrInterfaceType)fieldType).getTypeArguments().ifPresent(typeList -> typeList.forEach(argType -> {
                    GenericNode childClassGenericNode = new GenericNode();
                    if (argType instanceof ArrayType) {
                        GenericNode arrayTypeNode = fieldNode.getClassNode().getGenericNode(((ArrayType)argType).getComponentType().asString());
                        if (arrayTypeNode != null) {
                            ((ArrayType)argType).setComponentType(arrayTypeNode.getClassType());
                        }
                    } else {
                        GenericNode arrayTypeNode = fieldNode.getClassNode().getGenericNode(argType.asString());
                        if (arrayTypeNode != null) {
                            argType = arrayTypeNode.getClassType();
                        }
                    }
                    childClassGenericNode.setClassType((Type)argType);
                    childClassGenericNode.setFromJavaFile(childJavaFile);
                    childNode.addGenericNode(childClassGenericNode);
                }));
                try {
                    File childNodeJavaFile = ParseUtils.searchJavaFile(inJavaFile, fieldClassType2);
                    childNode.setClassFileName(childNodeJavaFile.getAbsolutePath());
                    if (!ParseUtils.inClassDependencyTree(fieldNode, fieldNode.getClassNode())) {
                        ParseUtils.parseClassNode(childNodeJavaFile, childNode);
                        break block21;
                    }
                    fieldNode.setLoopNode(Boolean.TRUE);
                }
                catch (JavaFileNotFoundException ex) {
                    LogUtils.warn(ex.getMessage() + ", we cannot found more information of it, you've better to make it a JavaBean", new Object[0]);
                    fieldNode.setType(isList != false ? "Object[]" : "Object");
                }
            } else {
                fieldNode.setType(isList != false ? unifyType + "[]" : unifyType);
            }
        }
    }

    private static boolean inClassDependencyTree(FieldNode fieldNode, ClassNode parentClassNode) {
        if (fieldNode.getChildNode().getClassFileName().equals(parentClassNode.getClassFileName())) {
            return true;
        }
        if (parentClassNode.getParentNode() == null) {
            return false;
        }
        return ParseUtils.inClassDependencyTree(fieldNode, parentClassNode.getParentNode());
    }

    public static boolean isModelType(String className) {
        return TYPE_MODEL.equals(ParseUtils.unifyType(className));
    }

    public static String unifyType(String className) {
        String[] cPaths = className.split("\\.");
        String rawType = cPaths[cPaths.length - 1];
        if ("byte".equalsIgnoreCase(rawType)) {
            return "byte";
        }
        if ("short".equalsIgnoreCase(rawType)) {
            return "short";
        }
        if ("int".equalsIgnoreCase(rawType) || "Integer".equalsIgnoreCase(rawType) || "BigInteger".equalsIgnoreCase(rawType)) {
            return "int";
        }
        if ("long".equalsIgnoreCase(rawType)) {
            return "long";
        }
        if ("float".equalsIgnoreCase(rawType)) {
            return "float";
        }
        if ("double".equalsIgnoreCase(rawType) || "BigDecimal".equalsIgnoreCase(rawType)) {
            return "double";
        }
        if ("boolean".equalsIgnoreCase(rawType)) {
            return "boolean";
        }
        if ("char".equalsIgnoreCase(rawType) || "Character".equalsIgnoreCase(rawType)) {
            return "char";
        }
        if ("String".equalsIgnoreCase(rawType)) {
            return "string";
        }
        if ("date".equalsIgnoreCase(rawType) || "ZonedDateTime".equalsIgnoreCase(rawType) || "LocalDateTime".equals(rawType)) {
            return "date";
        }
        if ("file".equalsIgnoreCase(rawType)) {
            return "file";
        }
        return TYPE_MODEL;
    }

    public static boolean isCollectionType(String className) {
        String[] cPaths = className.split("\\.");
        String genericType = cPaths[cPaths.length - 1];
        for (String cPath : cPaths) {
            if (!cPath.contains("<")) continue;
            genericType = cPath;
        }
        int genericLeftIndex = genericType.indexOf("<");
        String rawType = genericLeftIndex != -1 ? genericType.substring(0, genericLeftIndex) : genericType;
        String collectionClassName = "java.util." + rawType;
        try {
            Class<?> collectionClass = Class.forName(collectionClassName);
            return Collection.class.isAssignableFrom(collectionClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isExcludeParam(Parameter param) {
        String type = param.getTypeAsString();
        return type.equals("HttpServletRequest") || type.equals("HttpServletResponse") || type.equals("HttpSession");
    }
}

