/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Resources {
    private static boolean isDebug = false;
    private static String sResourcePath;
    private static String sUserCodeTplPath;

    public static InputStream getTemplateFile(String fileName) throws FileNotFoundException {
        if (isDebug) {
            return new FileInputStream(new File(sResourcePath, fileName));
        }
        return Resources.class.getClass().getResourceAsStream("/" + fileName);
    }

    static void setUserCodeTplPath(String userCodeTplPath) {
        sUserCodeTplPath = userCodeTplPath;
    }

    public static InputStream getCodeTemplateFile(String fileName) throws FileNotFoundException {
        if (sUserCodeTplPath != null) {
            File tplFile = new File(sUserCodeTplPath, fileName);
            if (tplFile.isFile() && tplFile.exists()) {
                return new FileInputStream(tplFile);
            }
            return Resources.class.getClass().getResourceAsStream("/" + fileName);
        }
        return Resources.getTemplateFile(fileName);
    }

    public static Template getFreemarkerTemplate(String fileName) throws IOException {
        Configuration conf = new Configuration(Configuration.VERSION_2_3_0);
        if (isDebug) {
            conf.setDirectoryForTemplateLoading(new File(sResourcePath));
        } else {
            conf.setClassForTemplateLoading(Resources.class, "/");
        }
        return conf.getTemplate(fileName);
    }

    public static void setDebug() {
        isDebug = true;
        sUserCodeTplPath = sResourcePath = System.getProperty("user.dir") + "/build/resources/main";
    }
}

